/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.common.internal;

import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraint;
import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IContextRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IFairShareRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IRequestClassReference;
import oracle.eclipse.tools.weblogic.descriptors.IResponseTimeRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorUtil;
import oracle.eclipse.tools.weblogic.ui.ddeditor.internal.WebLogicAppDescriptorEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SchedulingGuidelineReferenceJumpHandler
extends JumpActionHandler {
    protected boolean computeEnablementState() {
        Element element;
        if (super.computeEnablementState() && ((element = this.getPart().getModelElement()) instanceof IMinimumThreadsConstraintReference || element instanceof IMaximumThreadsConstraintReference || element instanceof ICapacityConstraintReference || element instanceof IRequestClassReference)) {
            final ISchedulingGuideline ref = (ISchedulingGuideline)element;
            Boolean result = (Boolean)WebLogicDescriptorUtil.runInContextOfAppDescriptor((Element)element, (WebLogicDescriptorUtil.Operation)new WebLogicDescriptorUtil.Operation<IWebLogicAppDescriptor, Boolean>(){

                public Boolean run(IWebLogicAppDescriptor descriptor) {
                    for (ISchedulingGuideline schedulingGuideline : descriptor.getCommonSchedulingGuidelines()) {
                        if (!SchedulingGuidelineReferenceJumpHandler.match(ref, schedulingGuideline)) continue;
                        return true;
                    }
                    return false;
                }
            });
            return result != null ? result : false;
        }
        return false;
    }

    protected Object run(Presentation context) {
        ISapphirePart part = this.getPart();
        final ISchedulingGuideline ref = (ISchedulingGuideline)part.getModelElement();
        ISchedulingGuideline target = (ISchedulingGuideline)WebLogicDescriptorUtil.runInContextOfAppDescriptor((Element)ref, (WebLogicDescriptorUtil.Operation)new WebLogicDescriptorUtil.Operation<IWebLogicAppDescriptor, ISchedulingGuideline>(){

            public ISchedulingGuideline run(IWebLogicAppDescriptor descriptor) {
                for (ISchedulingGuideline schedulingGuideline : descriptor.getCommonSchedulingGuidelines()) {
                    if (!SchedulingGuidelineReferenceJumpHandler.match(ref, schedulingGuideline)) continue;
                    return schedulingGuideline;
                }
                return null;
            }
        });
        if (target != null) {
            IFile refTargetFile = (IFile)target.adapt(IFile.class);
            WebLogicAppDescriptorEditor editor = null;
            if (refTargetFile.equals(ref.adapt(IFile.class))) {
                editor = (WebLogicAppDescriptorEditor)((Object)part.nearest(WebLogicAppDescriptorEditor.class));
            } else {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    IEditorDescriptor editorDescriptor = null;
                    try {
                        editorDescriptor = IDE.getEditorDescriptor((String)refTargetFile.getName());
                    }
                    catch (PartInitException partInitException) {}
                    if (editorDescriptor != null) {
                        try {
                            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)refTargetFile, (String)editorDescriptor.getId(), (boolean)true);
                            if (editorPart instanceof WebLogicAppDescriptorEditor) {
                                editor = (WebLogicAppDescriptorEditor)editorPart;
                            }
                        }
                        catch (PartInitException e) {
                            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                        }
                    }
                }
            }
            if (editor != null) {
                MasterDetailsEditorPagePart editorPagePart = (MasterDetailsEditorPagePart)editor.getEditorPagePart(WebLogicAppDescriptorEditor.PAGE_DESIGN);
                editor.showPage((SapphireEditorPagePart)editorPagePart);
                editorPagePart.outline().setSelection(WebLogicAppDescriptorEditor.NODE_WORK_MANAGERS);
            }
        }
        return null;
    }

    private static boolean match(ISchedulingGuideline ref, ISchedulingGuideline target) {
        if (ref instanceof IMinimumThreadsConstraintReference && target instanceof IMinimumThreadsConstraint || ref instanceof IMaximumThreadsConstraintReference && target instanceof IMaximumThreadsConstraint || ref instanceof ICapacityConstraintReference && target instanceof ICapacityConstraint || ref instanceof IRequestClassReference && (target instanceof IContextRequestClass || target instanceof IFairShareRequestClass || target instanceof IResponseTimeRequestClass)) {
            String x = ref.getName().text();
            String y = target.getName().text();
            if (x != null && y != null) {
                return x.equals(y);
            }
        }
        return false;
    }
}

