/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.credential;

import java.io.File;
import java.util.ArrayList;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeytoolUtil;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportCertActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        Element model = context.part().getModelElement();
        IKeystore keystore = (IKeystore)model;
        FileDialog dlg = new FileDialog(((SwtPresentation)context).shell());
        dlg.setFilterNames(new String[]{"cer"});
        String certPath = dlg.open();
        if (certPath == null || certPath.length() < 1) {
            return null;
        }
        KeystoreResource res = (KeystoreResource)keystore.resource();
        try {
            res.save();
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        String name = new File(certPath).getName();
        String cmd = "keytool -trustcacerts  -noprompt -importcert  -alias " + name.substring(0, name.length() - 4) + " -file " + certPath + " -keystore " + res.getStorePath() + " -storepass " + res.getPasswd();
        ArrayList list = new ArrayList();
        int n = KeytoolUtil.runCommandLine((String)cmd, list);
        if (n >= 0) {
            try {
                res.loadKeystore();
                res.refresh();
                keystore.getKeystoreEntries().refresh();
            }
            catch (Exception e) {
                IStatus sts = WlsUiPlugin.createErrorStatus(e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error open keystore", (IStatus)sts);
            }
        }
        return null;
    }
}

