/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.credential;

import java.util.ArrayList;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeypair;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeypairResource;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeytoolUtil;
import oracle.eclipse.tools.weblogic.ui.credential.NewKeypairDialog;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GenKeypairActionHandler
extends SapphireActionHandler {
    static final String GENKEY_CMD = "keytool  -genkey -keyalg RSA  -keysize 1024 -alias %s -dname \"cn=%s, ou=%s, o=%s, l=%s, s=%s, c=%s\"  -keypass %s -keystore %s -storepass %s";

    protected Object run(Presentation context) {
        ArrayList ret;
        String cmd;
        int n;
        Element model = context.part().getModelElement();
        IKeystore keystore = (IKeystore)model;
        KeystoreResource res = (KeystoreResource)keystore.resource();
        KeypairResource keyRes = new KeypairResource((Resource)res, keystore);
        try {
            res.save();
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        IKeypair keyPair = (IKeypair)IKeypair.TYPE.instantiate((Resource)keyRes);
        NewKeypairDialog kpDlg = new NewKeypairDialog(((SwtPresentation)context).shell(), (Element)keyPair);
        int n1 = kpDlg.open();
        if (n1 != 0) {
            keyPair.dispose();
            return null;
        }
        String keypass = (String)keyPair.getKeypass().content();
        if (keypass == null) {
            keypass = res.getPasswd();
        }
        if ((n = KeytoolUtil.runCommandLine((String)(cmd = String.format(GENKEY_CMD, keyPair.getAlias(), keyPair.getCommonName(), keyPair.getOrgUnit(), keyPair.getOrganization(), keyPair.getCity(), keyPair.getState(), keyPair.getCountry(), keypass, res.getStorePath(), res.getPasswd())), ret = new ArrayList())) >= 0) {
            try {
                res.loadKeystore();
                res.refresh();
                keystore.getKeystoreEntries().refresh();
                keyPair.dispose();
            }
            catch (Exception e) {
                IStatus sts = WlsUiPlugin.createErrorStatus(e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error open keystore", (IStatus)sts);
            }
        }
        return null;
    }
}

