/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.wsdlc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ant.WsdlBasedAntTaskArguments;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.bindings.IDefinitions;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.WsdlBasedAntWizard;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.WebServiceProjectWsdlLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.UiWsdlModelValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlLocationPage;
import oracle.eclipse.tools.webservices.ui.wizards.wsdlc.WsdlcArtifactsPage;
import oracle.eclipse.tools.webservices.ui.wizards.wsdlc.WsdlcOptionsPage;
import oracle.eclipse.tools.webservices.wsdlc.WsdlcAntScript;
import oracle.eclipse.tools.webservices.wsdlc.WsdlcArguments;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class WsdlcWizard
extends WsdlBasedAntWizard<WsdlcArguments>
implements IPageChangedListener {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.webservices.ui.WsdlcWizard";
    private WsdlcArtifactsPage artifactsPage;

    public WsdlcWizard(List<IFile> bindingsFiles) {
        this();
        ((WsdlcArguments)this.getArguments()).setBindings(bindingsFiles);
    }

    public WsdlcWizard() {
        super(Messages.wsdlc_wizard_title, Messages.wsdlc_process_title, new WsdlcArguments(), HELP_CONTEXT_ID);
        this.setDefaultPageImageDescriptor(WebServicesUIPlugin.Images.WS_BANNER.getImageDescriptor());
    }

    @Override
    public boolean performFinish() {
        block4: {
            try {
                this.setPackageNameFromBindings();
            }
            catch (Exception e) {
                boolean continueProcessing = DialogService.showConfirmDialog((String)Messages.wsdlc_wizard_title, (String)Messages.wsdlc_bindings_package_name_error);
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                if (continueProcessing) break block4;
                return false;
            }
        }
        if (super.performFinish()) {
            if (((WsdlcArguments)this.getArguments()).getExecuteAnt()) {
                this.openAndFormatFile();
            }
            return true;
        }
        return false;
    }

    private void openAndFormatFile() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IFile file = ((WsdlcArguments)WsdlcWizard.this.getArguments()).getServiceImplementationIFile();
                    if (file == null || !file.exists()) {
                        return;
                    }
                    ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
                    FormatAllAction action = new FormatAllAction((IWorkbenchSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                    action.runOnMultiple(new ICompilationUnit[]{cu});
                    cu.becomeWorkingCopy(null);
                    cu.commitWorkingCopy(true, null);
                    cu.discardWorkingCopy();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
                catch (PartInitException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
            }
        });
    }

    @Override
    public boolean validateModel(LightweightWsdlModel model) {
        return UiWsdlModelValidator.validateModel(model);
    }

    @Override
    public void addPages() {
        super.addPages();
        this.artifactsPage = new WsdlcArtifactsPage((WsdlcArguments)this.getArguments(), HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.artifactsPage);
        this.addPage((IWizardPage)new WsdlcOptionsPage((WsdlcArguments)this.getArguments()));
    }

    public void setContainer(IWizardContainer wizardContainer) {
        IPageChangeProvider provider;
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            provider = (IPageChangeProvider)container;
            provider.removePageChangedListener((IPageChangedListener)this);
        }
        if (wizardContainer instanceof IPageChangeProvider) {
            provider = (IPageChangeProvider)wizardContainer;
            provider.addPageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(wizardContainer);
    }

    @Override
    protected WsdlLocationPage createWsdlLocationPage(WsdlBasedAntTaskArguments args, String helpContextId) {
        return new WsdlLocationPage(args, new WebServiceProjectWsdlLocatorContentProvider(){

            @Override
            protected boolean isAcceptableProject(IProject project) {
                return WebServiceProject.isWebServiceProject((IProject)project);
            }
        }, this.getWsdlSelectionChangedListener(), Messages.wsdlc_wsdl_location_page_description, helpContextId);
    }

    public IWizardPage getStartingPage() {
        return ((WsdlcArguments)this.getArguments()).getWsdlModel() == null ? super.getStartingPage() : this.artifactsPage;
    }

    protected WsdlcAntScript createWlsAntScript() {
        return new WsdlcAntScript((WsdlcArguments)this.getArguments());
    }

    public void pageChanged(PageChangedEvent event) {
        if (((IWizardPage)event.getSelectedPage()).getName().startsWith("new")) {
            ((WsdlcArguments)this.getArguments()).setWsdlModel(null);
        }
    }

    private void setPackageNameFromBindings() throws IOException, ResourceStoreException {
        List bindings = ((WsdlcArguments)this.getArguments()).getBindings();
        String packageName = null;
        Iterator iterator = bindings.iterator();
        while (packageName == null && iterator.hasNext()) {
            IFile binding = (IFile)iterator.next();
            XmlResourceStore store = this.openModelStore(binding);
            IBindingsSet bindingsModel = (IBindingsSet)IBindingsSet.TYPE.instantiate((Resource)new RootXmlResource(store));
            ElementList definitions = bindingsModel.getDefinitions();
            for (IDefinitions def : definitions) {
                String value = def.getPackageName().text(false);
                if (value == null || value.isEmpty()) continue;
                packageName = value;
            }
        }
        if (packageName != null) {
            ((WsdlcArguments)this.getArguments()).setPackageName(packageName);
        }
    }

    private XmlResourceStore openModelStore(IFile file) throws IOException, ResourceStoreException {
        XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file));
        return store;
    }
}

