/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.wsdlc;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.AntArtifactsPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledIContainerSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledSrcRootSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import oracle.eclipse.tools.webservices.wsdlc.WsdlcArguments;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class WsdlcArtifactsPage
extends AntArtifactsPage {
    private static final String DEFAULT_JAVADOC_LOC = "javadoc";
    private final WsdlcArguments arguments;
    private static final String PAGE_NAME = WsdlcArtifactsPage.class.getSimpleName();
    private Combo serviceAndPortNames;
    ISWTObservableValue serviceAndPortNamesObservable;
    private final LabeledSrcRootSelector srcRootSelector;
    private Button createJavadocButton;
    private ISWTObservableValue createJavadocObservable;
    private final LabeledIContainerSelector jdocDirSelector;
    private final LabeledIContainerSelector jwsDirSelector;
    private boolean javadocLocationDeleteMessageSet = false;

    public WsdlcArtifactsPage(WsdlcArguments args, String helpContextId) {
        super((CommonWebServiceAntTaskArguments)args, PAGE_NAME, Messages.wsdlc_artifacts_page_wizard_title, Messages.wsdlc_artifacts_page_wizard_desc, (IPath)new Path("wsdlc_build.xml"), helpContextId);
        this.arguments = args;
        this.srcRootSelector = new LabeledSrcRootSelector(Messages.wsdlc_artifacts_page_src_label, Messages.wsdlc_artifacts_page_src_title, Messages.wsdlc_artifacts_page_src_msg, (CommonWebServiceAntTaskArguments)this.arguments, "implDestination");
        this.jdocDirSelector = new LabeledIContainerSelector(Messages.wsdlc_artifacts_page_jdoc_label, Messages.wsdlc_artifacts_page_jdoc_title, Messages.wsdlc_artifacts_page_jdoc_msg, (CommonWebServiceAntTaskArguments)this.arguments, "javadocDestination", (IPath)new Path(DEFAULT_JAVADOC_LOC), IFieldValidator.optional, IFieldValidator.directory);
        this.jwsDirSelector = new LabeledIContainerSelector(Messages.wsdlc_artifacts_page_jws_label, Messages.wsdlc_artifacts_page_jws_title, Messages.wsdlc_artifacts_page_jws_msg, (CommonWebServiceAntTaskArguments)this.arguments, "jwsDestination");
    }

    @Override
    protected void setupVisualElements(Composite parent) {
        Label serviceLabel = new Label(parent, 0);
        serviceLabel.setText(Messages.wsdlc_artifacts_page_port);
        serviceLabel.setLayoutData((Object)new GridData(4, 0, false, false));
        this.serviceAndPortNames = new Combo(parent, 12);
        this.serviceAndPortNames.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        group.setText(Messages.wsdlc_artifacts_page_generated);
        group.setLayout((Layout)new GridLayout(3, false));
        this.srcRootSelector.createControl((Composite)group);
        this.jwsDirSelector.createControl((Composite)group);
        this.createJavadocButton = this.createCheckBox((Composite)group, Messages.wsdlc_artifacts_page_generate_javadoc, 3);
        this.jdocDirSelector.createControl((Composite)group);
        this.jdocDirSelector.addModifyListener(new LabeledTextSelector.ITextChangeListener(){

            @Override
            public void textChanged(String text) {
                WsdlcArtifactsPage.this.validateJavaDocLocation(text);
            }
        });
        super.setupVisualElements(parent);
    }

    private void validateJavaDocLocation(String javadocLocationInTextBox) {
        int currentMsgType = this.getMessageType();
        if (currentMsgType == 0 || currentMsgType == 1 || currentMsgType == 2) {
            IProject project;
            IFolder javadocFolderLocation = null;
            if (javadocLocationInTextBox != null && javadocLocationInTextBox.trim().length() > 0 && (project = this.arguments.getProject()) != null) {
                javadocFolderLocation = project.getFolder(javadocLocationInTextBox.trim());
            }
            if (this.arguments.getGenerateJavadoc() && javadocFolderLocation != null && javadocFolderLocation.exists()) {
                this.setMessage(Messages.wsdlc_artifacts_page_jdoc_destination_warning, 2);
                this.javadocLocationDeleteMessageSet = true;
            } else if (this.javadocLocationDeleteMessageSet && currentMsgType == 2 && Messages.wsdlc_artifacts_page_jdoc_destination_warning.equals(this.getMessage())) {
                this.setMessage(null);
                this.javadocLocationDeleteMessageSet = false;
            }
        }
    }

    @Override
    protected void bindToContext(DataBindingContext context) {
        this.srcRootSelector.bindToContext(context);
        this.jdocDirSelector.bindToContext(context);
        this.jwsDirSelector.bindToContext(context);
        UpdateModelsSelectionAdapter adapter = new UpdateModelsSelectionAdapter();
        this.createJavadocButton.addSelectionListener((SelectionListener)adapter);
        this.createJavadocObservable = SWTObservables.observeSelection((Control)this.createJavadocButton);
        context.bindValue((IObservableValue)this.createJavadocObservable, BeansObservables.observeValue((Object)this.arguments, (String)"generateJavadoc"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
        UpdateValueStrategy service = new UpdateValueStrategy().setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                if (!(fromObject instanceof String)) {
                    throw new RuntimeException("MUST BE A STRING");
                }
                String s = (String)fromObject;
                int index = s.indexOf(46);
                return index < 0 ? "" : s.substring(0, index);
            }

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }
        });
        UpdateValueStrategy port = new UpdateValueStrategy().setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                if (!(fromObject instanceof String)) {
                    throw new RuntimeException("MUST BE A STRING");
                }
                String s = (String)fromObject;
                int index = s.indexOf(46);
                return index < 0 ? "" : s.substring(index + 1);
            }

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }
        });
        this.serviceAndPortNamesObservable = SWTObservables.observeSelection((Control)this.serviceAndPortNames);
        context.bindValue((IObservableValue)this.serviceAndPortNamesObservable, BeansObservables.observeValue((Object)this.arguments, (String)"serviceName"), service, (UpdateValueStrategy)NeverUpdateStrategy.instance);
        context.bindValue((IObservableValue)this.serviceAndPortNamesObservable, BeansObservables.observeValue((Object)this.arguments, (String)"portName"), port, (UpdateValueStrategy)NeverUpdateStrategy.instance);
        super.bindToContext(context);
    }

    @Override
    public void updateArguments() {
        assert (this.serviceAndPortNames != null);
        this.serviceAndPortNames.removeAll();
        for (Map.Entry entry : this.arguments.getWsdlModel().getPorts().entrySet()) {
            for (String port : (Collection)entry.getValue()) {
                this.serviceAndPortNames.add(String.valueOf((String)entry.getKey()) + '.' + port);
            }
        }
        String item = this.serviceAndPortNames.getItem(0);
        this.serviceAndPortNamesObservable.setValue((Object)item);
        this.jwsDirSelector.setDefault(WsdlcArtifactsPage.getBestJarFolderForProject(this.arguments.getProject()));
        this.srcRootSelector.resetDefaults();
        if (this.jvmContainsJavadoc()) {
            this.createJavadocButton.setEnabled(true);
            this.createJavadocButton.setText(Messages.wsdlc_artifacts_page_generate_javadoc);
            this.jdocDirSelector.setDefaultPath((IPath)new Path(DEFAULT_JAVADOC_LOC));
            this.jdocDirSelector.setEnabled(this.arguments.getGenerateJavadoc());
        } else {
            this.createJavadocObservable.setValue((Object)false);
            this.createJavadocButton.setEnabled(false);
            this.createJavadocButton.setText(Messages.wsdlc_artifacts_page_generate_javadoc_not_present);
            this.jdocDirSelector.setDefaultPath((IPath)new Path(""));
            this.jdocDirSelector.setEnabled(false);
        }
        super.updateArguments();
    }

    private boolean jvmContainsJavadoc() {
        IProject project = this.arguments.getProject();
        if (project == null) {
            return false;
        }
        try {
            String javaHome = WebServiceProject.getJavaHome((IProject)project);
            return javaHome != null && (new File(String.valueOf(javaHome) + "/bin/javadoc.exe").exists() || new File(String.valueOf(javaHome) + "/bin/javadoc").exists());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Button createCheckBox(Composite parent, String label, int horizontalSpan) {
        Button b = new Button(parent, 32);
        b.setText(label);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        b.setLayoutData((Object)gd);
        return b;
    }

    private class UpdateModelsSelectionAdapter
    extends SelectionAdapter {
        private UpdateModelsSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == WsdlcArtifactsPage.this.createJavadocButton) {
                WsdlcArtifactsPage.this.jdocDirSelector.setEnabled(WsdlcArtifactsPage.this.createJavadocButton.getSelection());
                WsdlcArtifactsPage.this.validateJavaDocLocation(WsdlcArtifactsPage.this.arguments.getJavadocDestinationAsString());
            }
        }
    }
}

