/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jws.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.ast.EditFailedException;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.template.WebServiceTemplateBean;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.IJWSExistingMethods;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.IJWSFromExistingModel;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.JWSFromExistingModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.JWSWriterContext;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.SoapBinding;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.SoapMessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;

public class UpdateExistingJavaMethods {
    public static Status execute(IJWSFromExistingModel operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Messages.generate_jws_from_java_execute_task_name, 3);
        try {
            try {
                Boolean addSei;
                String wsPortAttr;
                Boolean mtomEnabled;
                JWSFromExistingModelResource resource = (JWSFromExistingModelResource)operation.resource();
                JWSWriterContext jwsCtx = resource.getContext();
                jwsCtx.initializeEditContext();
                WriterContext ctx = jwsCtx.getWriterContext();
                WebServiceTemplateBean argument = jwsCtx.getArguments();
                HashMap<String, String> attr = new HashMap<String, String>();
                SoapBinding binding = (SoapBinding)((Object)operation.getSoapBinding().content());
                if (binding != null && SoapBinding.SOAP_BINDING_1_2.equals((Object)binding)) {
                    attr.put("value", "javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING");
                    WriterUtil.appendAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"javax.xml.ws.BindingType", attr, (WriterContext)ctx);
                }
                if ((mtomEnabled = (Boolean)operation.isMTOMEnabled().content()) != null && mtomEnabled.booleanValue()) {
                    WriterUtil.addMarkerAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"javax.xml.ws.soap.MTOM", (WriterContext)ctx);
                }
                attr = new HashMap();
                String wsNameAttr = operation.getWebServiceName().text();
                if (wsNameAttr != null) {
                    attr.put("serviceName", wsNameAttr);
                }
                if ((wsPortAttr = operation.getPortName().text()) != null) {
                    attr.put("portName", wsPortAttr);
                }
                if ((addSei = (Boolean)operation.isAddSeiEnabled().content()) != null && addSei.booleanValue()) {
                    attr.put("endpointInterface", String.valueOf(argument.getPackageName()) + "." + argument.getSeiClassName());
                }
                WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"javax.jws.WebService", attr, (WriterContext)ctx);
                UpdateExistingJavaMethods.buildPolicyAnnotation(jwsCtx);
                SoapMessageFormat soapMessage = (SoapMessageFormat)((Object)operation.getSoapMessageFormat().content());
                Map<String, IMethod> mapSig = resource.getMethodMap();
                if (addSei != null && addSei.booleanValue()) {
                    ArrayList<String> seiImports = new ArrayList<String>();
                    if (soapMessage != null) {
                        argument.setSoapMessageFormat(SoapMessageFormat.DOCUMENT_LITERAL_BARE.equals((Object)soapMessage));
                    }
                    Iterator methodIterator = operation.getMethods().iterator();
                    ArrayList<String> methodSignatures = new ArrayList<String>();
                    while (methodIterator.hasNext()) {
                        IJWSExistingMethods jwsMethod = (IJWSExistingMethods)methodIterator.next();
                        if (jwsMethod.isEnable() == null || !((Boolean)jwsMethod.isEnable().content()).booleanValue()) continue;
                        IMethod method = mapSig.get(jwsMethod.getMethodName().text());
                        try {
                            methodSignatures.add(UpdateExistingJavaMethods.methodSignature(method));
                            UpdateExistingJavaMethods.methodImports(method, seiImports, ctx);
                        }
                        catch (JavaModelException e) {
                            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                        }
                    }
                    argument.setMethods(methodSignatures);
                    argument.setSeiImports(seiImports);
                } else {
                    if (soapMessage != null && SoapMessageFormat.DOCUMENT_LITERAL_BARE.equals((Object)soapMessage)) {
                        attr = new HashMap();
                        attr.put("parameterStyle", "BARE");
                        WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"javax.jws.soap.SOAPBinding", attr, (WriterContext)ctx);
                    }
                    for (IJWSExistingMethods jwsMethod : operation.getMethods()) {
                        if (jwsMethod.isEnable() == null || ((Boolean)jwsMethod.isEnable().content()).booleanValue()) continue;
                        IMethod method = mapSig.get(jwsMethod.getMethodName().text());
                        try {
                            MethodDeclaration declar = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)method, (CompilationUnit)ctx.getCompilationUnit());
                            attr = new HashMap();
                            attr.put("exclude", "true");
                            WriterUtil.addAnnotation((BodyDeclaration)declar, (String)"javax.jws.WebMethod", attr, (WriterContext)ctx);
                        }
                        catch (JavaModelException e) {
                            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                        }
                    }
                }
                monitor.worked(1);
            }
            catch (EditFailedException e) {
                Status status = Status.createErrorStatus((String)e.getLocalizedMessage());
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    public static void buildPolicyAnnotation(JWSWriterContext jwsCtx) throws EditFailedException {
        block11: {
            HashMap<String, String> attrs;
            Set policies;
            WebServiceTemplateBean argument;
            WriterContext ctx;
            block9: {
                block10: {
                    ctx = jwsCtx.getWriterContext();
                    argument = jwsCtx.getArguments();
                    policies = argument.getPolicies();
                    if (policies == null) {
                        return;
                    }
                    attrs = new HashMap<String, String>();
                    if (!argument.hasMultiplePolicies()) break block9;
                    if (!WebServiceTemplateBean.PolicyRuntimeType.OWSM.equals((Object)argument.getPolicyType())) break block10;
                    NormalAnnotation parent = WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.wsee.jws.jaxws.owsm.SecurityPolicies", null, (WriterContext)ctx);
                    WriterUtil.ensureImport((ASTNode)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.wsee.jws.jaxws.owsm.SecurityPolicy", (WriterContext)ctx);
                    for (String policy : policies) {
                        attrs = new HashMap();
                        attrs.put("uri", policy);
                        WriterUtil.addAnnotationArrayMember((Annotation)parent, (String)"value", (String)"weblogic.wsee.jws.jaxws.owsm.SecurityPolicy", attrs, (WriterContext)ctx);
                    }
                    break block11;
                }
                if (!WebServiceTemplateBean.PolicyRuntimeType.WLS.equals((Object)argument.getPolicyType())) break block11;
                NormalAnnotation parent = WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.jws.Policies", null, (WriterContext)ctx);
                WriterUtil.ensureImport((ASTNode)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.jws.Policy", (WriterContext)ctx);
                for (String policy : policies) {
                    attrs = new HashMap();
                    attrs.put("uri", policy);
                    WriterUtil.addAnnotationArrayMember((Annotation)parent, (String)"value", (String)"weblogic.jws.Policy", attrs, (WriterContext)ctx);
                }
                break block11;
            }
            if (!WebServiceTemplateBean.PolicyRuntimeType.NONE.equals((Object)argument.getPolicyType()) && policies.size() == 1) {
                if (WebServiceTemplateBean.PolicyRuntimeType.OWSM.equals((Object)argument.getPolicyType())) {
                    policies.iterator();
                    for (String policy : policies) {
                        attrs = new HashMap();
                        attrs.put("uri", policy);
                        WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.wsee.jws.jaxws.owsm.SecurityPolicy", attrs, (WriterContext)ctx);
                    }
                } else if (WebServiceTemplateBean.PolicyRuntimeType.WLS.equals((Object)argument.getPolicyType())) {
                    for (String policy : policies) {
                        attrs = new HashMap();
                        attrs.put("uri", policy);
                        WriterUtil.addAnnotation((BodyDeclaration)ReaderUtil.getPrimaryType((CompilationUnit)ctx.getCompilationUnit()), (String)"weblogic.jws.Policy", attrs, (WriterContext)ctx);
                    }
                }
            }
        }
    }

    public static String methodSignature(IMethod method) throws JavaModelException {
        return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)true, (boolean)true);
    }

    public static void methodImports(IMethod method, List<String> imports, WriterContext ctx) throws JavaModelException {
        String[] paramTypes;
        String[] stringArray = paramTypes = method.getParameterTypes();
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String pType = stringArray[n2];
            UpdateExistingJavaMethods.imports(method.getDeclaringType(), imports, pType, ctx);
            ++n2;
        }
        String returnType = method.getReturnType();
        if (returnType != null) {
            UpdateExistingJavaMethods.imports(method.getDeclaringType(), imports, returnType, ctx);
        }
    }

    private static void imports(IType dType, List<String> list, String type, WriterContext ctx) {
        String importType = Signature.toString((String)type);
        if (!ClassUtil.isPrimitiveType((String)importType)) {
            String[] typeArguments;
            String typeName = ClassUtil.resolveType((String)importType, (IType)dType);
            String resolvedTypeName = ClassUtil.stripTypeParameters((String)typeName);
            if (UpdateExistingJavaMethods.checkPackage(Signature.getQualifier((String)resolvedTypeName), ctx.getCompilationUnit())) {
                list.add(resolvedTypeName);
            }
            if ((typeArguments = Signature.getTypeArguments((String)type)).length > 0) {
                int i = 0;
                while (i < typeArguments.length) {
                    String curr = typeArguments[i];
                    UpdateExistingJavaMethods.imports(dType, list, curr, ctx);
                    ++i;
                }
            }
        }
    }

    private static boolean checkPackage(String pkg, CompilationUnit cu) {
        if (pkg != null) {
            if (pkg.equals("java.lang")) {
                return false;
            }
            PackageDeclaration currentPkg = cu.getPackage();
            if (currentPkg != null && currentPkg.getName().getFullyQualifiedName().equals(pkg)) {
                return false;
            }
        }
        return true;
    }
}

