/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jaxb;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.jaxb.JaxbXJCAntScript;
import oracle.eclipse.tools.webservices.jaxb.JaxbXJCArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.AntWrapperWizard;
import oracle.eclipse.tools.webservices.ui.wizards.jaxb.JaxbArtifactLocationPage;
import oracle.eclipse.tools.webservices.ui.wizards.jaxb.JaxbXJCOptionsPage;
import oracle.eclipse.tools.webservices.ui.wizards.jaxb.JaxbXJCRequiredPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class JaxbXJCWizard
extends AntWrapperWizard {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.webservices.ui.JaxbWizard";
    private static final String XSD_CONTENT_TYPE = "org.eclipse.wst.xsd.core.xsdsource";
    private JaxbXJCArguments arguments = new JaxbXJCArguments();
    private JaxbXJCRequiredPage requiredPage;
    private JaxbArtifactLocationPage xsdSelectionPage;
    private JaxbXJCOptionsPage xsdOptionsPage;
    private boolean schemasSelected;

    public JaxbXJCWizard() {
        super(Messages.jaxb_xjc_wizard_title, Messages.jaxb_xjc_wizard_process_title);
        this.setDefaultPageImageDescriptor(WebServicesUIPlugin.Images.WS_JAXB_BANNER.getImageDescriptor());
        this.setDialogSettings(WebServicesUIPlugin.getDefault().getDialogSettings());
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        List<IFile> xsds = this.getFilesAsList(selection);
        if (xsds == null || xsds.isEmpty() || xsds.get(0) == null) {
            return;
        }
        IProject project = xsds.get(0).getProject();
        if (project != null) {
            this.arguments.setProject(project);
        }
        if (!EclipseFileUtil.isContentType((IFile)xsds.get(0), (String)XSD_CONTENT_TYPE)) {
            return;
        }
        this.schemasSelected = xsds != null && !xsds.isEmpty();
        this.setNeedsProgressMonitor(true);
        if (this.schemasSelected) {
            assert (project == xsds.get(0).getProject()) : Messages.jaxb_xjc_xsd_project_match;
            this.arguments.setSchemas(xsds);
        }
    }

    private List<IFile> getFilesAsList(IStructuredSelection selection) {
        ArrayList<IFile> files = new ArrayList<IFile>(selection.size());
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IFile) {
                files.add((IFile)obj);
            } else if (obj instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)obj;
                files.add((IFile)adaptable.getAdapter(IFile.class));
            }
            ++n2;
        }
        return files;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp((Control)this.getShell(), HELP_CONTEXT_ID);
        if (this.schemasSelected) {
            this.updatePages();
        }
    }

    public void addPages() {
        this.requiredPage = new JaxbXJCRequiredPage(this.arguments, HELP_CONTEXT_ID);
        this.xsdOptionsPage = new JaxbXJCOptionsPage(this.arguments, HELP_CONTEXT_ID);
        this.xsdSelectionPage = new JaxbArtifactLocationPage(this.arguments, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.xsdSelectionPage);
        this.addPage((IWizardPage)this.requiredPage);
        this.addPage((IWizardPage)this.xsdOptionsPage);
    }

    public IWizardPage getStartingPage() {
        return this.schemasSelected ? this.requiredPage : this.xsdSelectionPage;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean assignTempDirectory() {
        File jaxb_xjcWorkingDir = new File(WebServicesCorePlugin.getDefault().getStateLocation().toFile(), "jaxb_xjc");
        try {
            if (jaxb_xjcWorkingDir.exists()) {
                EclipseFileUtil.deleteFile((File)jaxb_xjcWorkingDir);
            }
            if (!jaxb_xjcWorkingDir.mkdirs()) {
                DialogService.showErrorDialog((String)Messages.bind((String)Messages.jaxb_xjc_wizard_cannot_create_tmpdir, (Object)jaxb_xjcWorkingDir.getAbsolutePath()));
                return false;
            }
        }
        catch (Exception exception) {
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.jaxb_xjc_wizard_cannot_create_tmpdir, (Object)jaxb_xjcWorkingDir.getAbsolutePath()));
            return false;
        }
        this.arguments.setTargetDir(jaxb_xjcWorkingDir);
        return true;
    }

    @Override
    public boolean performFinish() {
        return this.assignTempDirectory() ? super.performFinish() : false;
    }

    protected JaxbXJCAntScript createWlsAntScript() {
        return new JaxbXJCAntScript(this.arguments);
    }

    @Override
    protected void updatePages() {
        super.updatePages();
    }
}

