/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.jaxb;

import java.util.ArrayList;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.jaxb.JaxbXJCArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.ListOfFilesLocationGroup;
import oracle.eclipse.tools.webservices.ui.wizards.jaxb.JaxbXJCWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JaxbArtifactLocationPage
extends WizardPage
implements IAntWrapperPage,
SelectionListener {
    public static final String PAGE_NAME = "JaxbArtifactLocationPage";
    private final ListOfFilesLocationGroup schemasGroup;
    private final JaxbXJCArguments arguments;
    private Combo projectCombo;
    private String helpContextId;

    public JaxbArtifactLocationPage(JaxbXJCArguments args, String helpContextId) {
        super(PAGE_NAME, Messages.jaxb_artifact_location_page_title, null);
        this.setDescription(Messages.jaxb_artifact_location_page_description);
        this.arguments = args;
        this.helpContextId = helpContextId;
        ListOfFilesLocationGroup.IContentChangeListener listener = new ListOfFilesLocationGroup.IContentChangeListener(){

            @Override
            public void contentChanged() {
                ((JaxbXJCWizard)JaxbArtifactLocationPage.this.getWizard()).updatePages();
                JaxbArtifactLocationPage.this.setPageComplete(!JaxbArtifactLocationPage.this.arguments.getSchemas().isEmpty());
            }
        };
        this.schemasGroup = new ListOfFilesLocationGroup((CommonWebServiceAntTaskArguments)this.arguments, "schemas", Messages.jaxb_artifact_location_page_schema_label, Messages.jaxb_artifact_location_page_schema_dialog_title, Messages.jaxb_artifact_location_page_schema_dialog_msg, listener, IFieldValidator.schemaFile);
        this.setPageComplete(!this.arguments.getSchemas().isEmpty());
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 4);
        GridLayout gl = new GridLayout(3, false);
        main.setLayout((Layout)gl);
        Label label = new Label(main, 0);
        label.setText(Messages.jaxb_artifact_location_page_project);
        label.setLayoutData((Object)new GridData(4, 0, false, false));
        this.projectCombo = new Combo(main, 12);
        this.projectCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.projectCombo.addSelectionListener((SelectionListener)this);
        Label spacer = new Label(main, 0);
        spacer.setText("");
        spacer.setVisible(false);
        spacer.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.schemasGroup.createControl(main);
        this.setControl((Control)main);
        this.updateProjectCombo();
    }

    private void updateProjectCombo() {
        IProject currentProject = this.arguments.getProject();
        int selected = 0;
        ArrayList<String> items = new ArrayList<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WebServiceProject.isWebServiceProject((IProject)project)) {
                items.add(project.getName());
                if (project == currentProject) {
                    selected = items.size() - 1;
                }
            }
            ++n2;
        }
        this.projectCombo.setItems(items.toArray(new String[items.size()]));
        if (selected < this.projectCombo.getItemCount()) {
            this.projectCombo.select(selected);
            if (currentProject == null) {
                this.arguments.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectCombo.getItem(selected)));
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Combo c = (Combo)e.getSource();
        int index = c.getSelectionIndex();
        String[] items = c.getItems();
        String selected = items[index];
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(selected);
        this.arguments.setProject(project);
        this.schemasGroup.removeAllFiles();
        this.setPageComplete(false);
    }

    @Override
    public void updateArguments() {
        this.updateProjectCombo();
        this.schemasGroup.updateList();
    }

    public final void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }
}

