/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;

public final class WsdlTableRow {
    private int rowIndex;
    private Object[] data = new Object[2];

    public WsdlTableRow(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public final void setData(IResource wsdl, IPath location) {
        this.data[0] = wsdl;
        this.data[1] = location;
    }

    public final Object getData(WsdlTableColumnType type) {
        return this.getData(type.getIndex());
    }

    public final Object getData(int columnIndex) {
        if (WsdlTableColumnType.values().length > columnIndex) {
            return this.data[columnIndex];
        }
        return null;
    }

    public final void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public final int getRowIndex() {
        return this.rowIndex;
    }

    public final String getString(int columnIndex) {
        if (WsdlTableColumnType.values().length > columnIndex) {
            Object columnData = this.data[columnIndex];
            return WsdlTableColumnType.getWsdlTableColumnType(columnIndex).getString(columnData);
        }
        return null;
    }

    public static enum WsdlTableColumnType {
        WSDL(0),
        LOCATION(1);

        private int index;

        private WsdlTableColumnType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static WsdlTableColumnType getWsdlTableColumnType(int columnIndex) {
            if (columnIndex == WSDL.getIndex()) {
                return WSDL;
            }
            if (columnIndex == LOCATION.getIndex()) {
                return LOCATION;
            }
            return null;
        }

        public boolean isColumnType(int columnIndex) {
            return this.getIndex() == columnIndex;
        }

        public String getString(Object columnData) {
            if (this.equals((Object)WSDL)) {
                return ((IResource)columnData).getName();
            }
            if (this.equals((Object)LOCATION)) {
                return ((IPath)columnData).toString();
            }
            return null;
        }

        public Image getImage() {
            if (this.equals((Object)WSDL)) {
                return WebServicesUIPlugin.Images.WS_WSDL.getImage();
            }
            return null;
        }
    }
}

