/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ant.WsdlBasedAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.WebServiceProjectWsdlLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class WsdlLocationPage
extends WizardPage
implements IAntWrapperPage {
    public static final String PAGE_NAME = "WsdlLocationPage";
    protected IFileSelectionChangedListener wsdlSelectionChangedListener;
    protected Composite locationComposite;
    private Text wsdlFileName;
    private TreeViewer treeViewer;
    private WebServiceProjectWsdlLocatorContentProvider wsdlLocatorContentProvider;
    private boolean isPageComplete = false;
    private String helpContextId;
    private IProject selectionProject;
    protected final String descriptionText;
    private final WsdlBasedAntTaskArguments arguments;

    public WsdlLocationPage(WsdlBasedAntTaskArguments args, WebServiceProjectWsdlLocatorContentProvider wsdlLocatorContentProvider, IFileSelectionChangedListener wsdlSelectionChangedListener, String helpContextId) {
        this(args, wsdlLocatorContentProvider, wsdlSelectionChangedListener, Messages.wsdl_location_page_description, helpContextId);
    }

    public WsdlLocationPage(WsdlBasedAntTaskArguments args, WebServiceProjectWsdlLocatorContentProvider wsdlLocatorContentProvider, IFileSelectionChangedListener wsdlSelectionChangedListener, String description, String helpContextId) {
        super(PAGE_NAME, Messages.wsdl_location_page_title, null);
        this.wsdlLocatorContentProvider = wsdlLocatorContentProvider;
        this.wsdlSelectionChangedListener = wsdlSelectionChangedListener;
        this.arguments = args;
        this.descriptionText = description;
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        main.setLayout((Layout)layout);
        this.createLocalLocationComposite(main);
        this.setControl((Control)main);
    }

    public void setPageComplete(boolean complete) {
        this.isPageComplete = complete;
        super.setPageComplete(complete);
    }

    protected void createLocalLocationComposite(Composite main) {
        this.setDescription(this.descriptionText);
        this.locationComposite = new Composite(main, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 5;
        gl.marginTop = 10;
        gl.marginBottom = 10;
        this.locationComposite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.minimumHeight = 250;
        gd.heightHint = 250;
        this.locationComposite.setLayoutData((Object)gd);
        Label label = new Label(this.locationComposite, 0);
        label.setText(Messages.wsdl_location_page_wsdl_file_label_text);
        this.wsdlFileName = new Text(this.locationComposite, 2052);
        this.wsdlFileName.setEditable(false);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 80;
        gd.minimumWidth = 50;
        gd.horizontalAlignment = 4;
        this.wsdlFileName.setLayoutData((Object)gd);
        DrillDownComposite drillDown = new DrillDownComposite(this.locationComposite, 2048);
        gd = new GridData(4, 4, true, true);
        drillDown.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)this.wsdlLocatorContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.updateArguments();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                WsdlLocationPage.this.selectionChanged(selection, true);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (WsdlLocationPage.this.treeViewer.getExpandedState(item)) {
                        WsdlLocationPage.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        WsdlLocationPage.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        Tree tree = this.treeViewer.getTree();
        if (tree.getItemCount() > 0) {
            tree.setFocus();
            tree.select(tree.getItem(0));
        }
    }

    private void selectionChanged(IStructuredSelection selection, boolean doOldCheck) {
        Object selElement = selection.getFirstElement();
        IFile wsdlFile = null;
        if (selElement instanceof IResource) {
            IPath path = ((IResource)selElement).getFullPath();
            String oldWsdl = this.wsdlFileName.getText();
            String newWsdl = path.toPortableString();
            if (doOldCheck && oldWsdl.equals(newWsdl)) {
                return;
            }
            this.wsdlFileName.setText(newWsdl);
            if (selElement instanceof IFile) {
                wsdlFile = (IFile)selElement;
            } else {
                selection = null;
            }
            this.selectionProject = ((IResource)selElement).getProject();
        } else {
            selection = null;
        }
        this.isPageComplete = this.wsdlSelectionChangedListener.fileSelectionChanged(selection, wsdlFile);
        this.setPageComplete(this.isPageComplete);
    }

    protected void refreshState() {
        this.selectionChanged((IStructuredSelection)this.treeViewer.getSelection(), false);
    }

    protected IProject getSelectedProject() {
        return this.selectionProject;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    @Override
    public void updateArguments() {
        IFile wsdl = this.arguments.getWsdlIFile();
        if (wsdl != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)wsdl), true);
            this.setPageComplete(true);
        }
    }

    public void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }
}

