/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class UrlBrowserDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "DestinationDialogSettings";
    private String originalURL = null;
    private String result;
    private Browser browser;
    private Button okButton;
    private Text location;
    private final String title;
    private final String message;

    public UrlBrowserDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.message = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this.browser.setFocus();
        this.setTitle(this.title);
        this.setMessage(this.message);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        ToolBar toolbar = new ToolBar(composite, 0);
        ToolItem itemBack = new ToolItem(toolbar, 8);
        itemBack.setToolTipText(Messages.wizards_common_back_tooltip);
        itemBack.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_LEFT));
        ToolItem itemForward = new ToolItem(toolbar, 8);
        itemForward.setToolTipText(Messages.wizards_common_forward_tooltip);
        itemForward.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_RIGHT));
        ToolItem itemStop = new ToolItem(toolbar, 8);
        itemStop.setToolTipText(Messages.wizards_common_stop_tooltip);
        itemStop.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DELETE));
        ToolItem itemRefresh = new ToolItem(toolbar, 8);
        itemRefresh.setToolTipText(Messages.wizards_common_refresh_tooltip);
        itemRefresh.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_DIAGRAM_REFRESH));
        ToolItem itemGo = new ToolItem(toolbar, 8);
        itemGo.setImage(WebServicesUIPlugin.Images.START.getImage());
        itemGo.setToolTipText(Messages.wizards_common_go_tooltip);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        toolbar.setLayoutData((Object)data);
        Label labelAddress = new Label(composite, 0);
        labelAddress.setText(Messages.wizards_common_address_tooltip);
        this.location = new Text(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.location.setLayoutData((Object)data);
        try {
            this.browser = new Browser(composite, 0);
        }
        catch (SWTError e) {
            Status sts = new Status(4, "oracle.eclipse.tools.webservices.ui", e.getLocalizedMessage());
            ErrorDialog.openError((Shell)this.getShell(), (String)WebServicesUIMessages.getString("UrlBrowserDialog_0"), (String)WebServicesUIMessages.getString("UrlBrowserDialog_1"), (IStatus)sts);
            return null;
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.browser.setLayoutData((Object)data);
        Label status = new Label(composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        status.setLayoutData((Object)data);
        final ProgressBar progressBar = new ProgressBar(composite, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        progressBar.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ToolItem item = (ToolItem)event.widget;
                String string = item.getToolTipText();
                if (string.equals(Messages.wizards_common_back_tooltip)) {
                    UrlBrowserDialog.this.browser.back();
                } else if (string.equals(Messages.wizards_common_forward_tooltip)) {
                    UrlBrowserDialog.this.browser.forward();
                } else if (string.equals(Messages.wizards_common_stop_tooltip)) {
                    UrlBrowserDialog.this.browser.stop();
                } else if (string.equals(Messages.wizards_common_refresh_tooltip)) {
                    UrlBrowserDialog.this.browser.refresh();
                } else if (string.equals(Messages.wizards_common_go_tooltip)) {
                    UrlBrowserDialog.this.browser.setUrl(UrlBrowserDialog.this.location.getText());
                }
            }
        };
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                int ratio = event.current * 100 / event.total;
                progressBar.setSelection(ratio);
            }

            public void completed(ProgressEvent event) {
                progressBar.setSelection(0);
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                if (event.top) {
                    UrlBrowserDialog.this.location.setText(event.location);
                }
            }

            public void changing(LocationEvent event) {
            }
        });
        itemBack.addListener(13, listener);
        itemForward.addListener(13, listener);
        itemStop.addListener(13, listener);
        itemRefresh.addListener(13, listener);
        itemGo.addListener(13, listener);
        this.location.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                UrlBrowserDialog.this.browser.setUrl(UrlBrowserDialog.this.location.getText());
            }
        });
        return parentComposite;
    }

    public String getResult() {
        return this.result;
    }

    private void initializeControls() {
        if (this.originalURL != null) {
            this.location.setText(this.originalURL);
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        this.result = this.browser.getUrl();
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    public void setOriginalURL(String originalURL) {
        this.originalURL = originalURL;
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = WebServicesUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

