/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class RelativePathStringToIFileConverter
extends Converter {
    private final boolean isOptional;
    private final boolean allowParentEarProjects;
    private CommonWebServiceAntTaskArguments arguments;

    public RelativePathStringToIFileConverter(CommonWebServiceAntTaskArguments arguments) {
        this(arguments, false, false);
    }

    public RelativePathStringToIFileConverter(CommonWebServiceAntTaskArguments args, boolean optional, boolean allowParentEarProjects) {
        super(String.class, IFile.class);
        this.arguments = args;
        this.isOptional = optional;
        this.allowParentEarProjects = allowParentEarProjects;
    }

    public Object convert(Object fromObject) {
        block8: {
            block7: {
                if (this.arguments.getProject() != null) break block7;
                return null;
            }
            if (!this.isOptional || !"".equals(fromObject)) break block8;
            return null;
        }
        try {
            String fromString;
            if (this.allowParentEarProjects && (fromString = (String)fromObject).startsWith("/")) {
                IProject[] iProjectArray = this.arguments.getProject().getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject currentProject = iProjectArray[n2];
                    if (fromString.startsWith(currentProject.getFullPath().toPortableString())) {
                        IFile file = this.arguments.getProject().getWorkspace().getRoot().getFile((IPath)new Path(fromString));
                        return file;
                    }
                    ++n2;
                }
            }
            IFile file = this.arguments.getProject().getFile(fromObject.toString());
            return file;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.invalid_path, (Object)fromObject), e);
        }
    }
}

