/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileSelectionTree;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileToRelativePathStringConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ListOfFilesLocationGroup {
    private Button removeFile;
    private Button addFile;
    private org.eclipse.swt.widgets.List fileList;
    private IStatus ERROR_STATUS = new Status(4, "oracle.eclipse.tools.webservices.ui", "");
    private IStatus OK_STATUS = new Status(0, "oracle.eclipse.tools.webservices.ui", "");
    private final IFileToRelativePathStringConverter converter;
    private final CommonWebServiceAntTaskArguments arguments;
    private final String labelText;
    private final String dialogTitle;
    private final String dialogMessage;
    private final IFieldValidator[] validators;
    private final Method setBinding;
    private final Method getBinding;
    private final IContentChangeListener listener;

    public ListOfFilesLocationGroup(CommonWebServiceAntTaskArguments args, String modelKey, String labelTxt, String dTitle, String dMsg, IFieldValidator ... validatorsParam) {
        this(args, modelKey, labelTxt, dTitle, dMsg, (IContentChangeListener)null, validatorsParam);
    }

    public ListOfFilesLocationGroup(CommonWebServiceAntTaskArguments args, String modelKey, String labelTxt, String dTitle, String dMsg, IContentChangeListener contentListener, IFieldValidator ... validatorsParam) {
        this.arguments = args;
        this.converter = new IFileToRelativePathStringConverter(this.arguments, false);
        this.validators = validatorsParam != null ? validatorsParam : new IFieldValidator[]{};
        this.dialogTitle = dTitle;
        this.dialogMessage = dMsg;
        this.labelText = labelTxt;
        String binding = String.valueOf(modelKey.substring(0, 1).toUpperCase()) + modelKey.substring(1);
        this.setBinding = this.getMethodBinding("set" + binding, List.class);
        this.getBinding = this.getMethodBinding("get" + binding, new Class[0]);
        assert (this.getBinding.getReturnType() == List.class);
        this.listener = contentListener;
    }

    private Method getMethodBinding(String methodName, Class ... args) {
        try {
            return this.arguments.getClass().getMethod(methodName, args);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public final void createControl(Composite parent) {
        assert (parent.getLayout() instanceof GridLayout);
        assert (((GridLayout)parent.getLayout()).numColumns == 3);
        Label dlgLabel = new Label(parent, 0);
        dlgLabel.setText(this.labelText);
        dlgLabel.setLayoutData((Object)new GridData(1, 0, false, false));
        this.fileList = new org.eclipse.swt.widgets.List(parent, 2052);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 30;
        this.fileList.setLayoutData((Object)gd);
        this.fileList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListOfFilesLocationGroup.this.removeFile.setEnabled(ListOfFilesLocationGroup.this.fileList.getSelectionCount() > 0);
            }
        });
        Composite bindingAddRemove = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        bindingAddRemove.setLayout((Layout)layout);
        bindingAddRemove.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addFile = new Button(bindingAddRemove, 8);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.addFile.setLayoutData((Object)gd);
        this.addFile.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
        this.addFile.setToolTipText(Messages.wizards_common_add_tooltip);
        this.removeFile = new Button(bindingAddRemove, 8);
        this.removeFile.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DELETE));
        this.removeFile.setEnabled(false);
        this.removeFile.setToolTipText(Messages.wizards_common_remove_tooltip);
        this.addFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListOfFilesLocationGroup.this.handleAddFile();
            }
        });
        this.removeFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ListOfFilesLocationGroup.this.handleRemoveFile();
            }
        });
    }

    public void addFiles(IFile ... files) {
        if (files == null) {
            return;
        }
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file != null) {
                this.addToFileList(file.getProjectRelativePath().toPortableString());
            }
            ++n2;
        }
    }

    public List<IFile> getFiles() {
        IProject project = this.arguments.getProject();
        ArrayList<IFile> files = new ArrayList<IFile>(this.fileList.getItemCount());
        String[] stringArray = this.fileList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            files.add(project.getFile(file));
            ++n2;
        }
        return files;
    }

    private void handleRemoveFile() {
        this.fileList.remove(this.fileList.getSelectionIndices());
        this.updateModel(this.getFiles());
        this.removeFile.setEnabled(false);
        this.fileList.deselectAll();
        if (this.listener != null) {
            this.listener.contentChanged();
        }
    }

    public void removeAllFiles() {
        this.fileList.removeAll();
        this.updateModel(Collections.emptyList());
    }

    protected void handleAddFile() {
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        FileSelectionTree dialog = new FileSelectionTree(this.addFile.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider, this.validators);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource r = (IResource)element;
                    if (r.isDerived() || r.getName().startsWith(".")) {
                        return false;
                    }
                    if (r.getType() == 1) {
                        IFieldValidator[] iFieldValidatorArray = ListOfFilesLocationGroup.this.validators;
                        int n = iFieldValidatorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFieldValidator v = iFieldValidatorArray[n2];
                            IStatus s = v.validate(ListOfFilesLocationGroup.this.labelText, r);
                            if (s == IFieldValidator.SKIP_FURTHER_VALIDATION) {
                                return true;
                            }
                            if (!s.isOK()) {
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return ListOfFilesLocationGroup.this.ERROR_STATUS;
                }
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IFile)) {
                        return ListOfFilesLocationGroup.this.ERROR_STATUS;
                    }
                    IFieldValidator[] iFieldValidatorArray = ListOfFilesLocationGroup.this.validators;
                    int n = iFieldValidatorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFieldValidator v = iFieldValidatorArray[n2];
                        IStatus s = v.validate(ListOfFilesLocationGroup.this.labelText, (IFile)selection[i]);
                        if (s == IFieldValidator.SKIP_FURTHER_VALIDATION) break;
                        if (!s.isOK()) {
                            return ListOfFilesLocationGroup.this.ERROR_STATUS;
                        }
                        ++n2;
                    }
                    ++i;
                }
                return ListOfFilesLocationGroup.this.OK_STATUS;
            }
        });
        IProject initElement = this.arguments.getProject();
        dialog.setInput(initElement != null ? initElement : ResourcesPlugin.getWorkspace());
        dialog.setInitialSelection(initElement);
        dialog.setTitle(this.dialogTitle);
        dialog.setMessage(this.dialogMessage);
        int resultCode = dialog.open();
        if (resultCode != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        assert (result != null) : "Null result when dialog was not cancelled";
        this.parseResult(result);
        this.updateModel(this.getFiles());
        this.removeFile.setEnabled(false);
        this.fileList.deselectAll();
        if (this.listener != null) {
            this.listener.contentChanged();
        }
    }

    private void parseResult(Object[] result) {
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IFile ifile;
            String ext;
            Object o = objectArray[n2];
            if (o instanceof IFile && (ext = (ifile = (IFile)o).getFileExtension()) != null) {
                this.addToFileList(this.converter.convert(ifile).toString());
            }
            ++n2;
        }
    }

    private void addToFileList(String item) {
        if (this.fileList == null || item == null) {
            return;
        }
        if (this.fileList.indexOf(item) == -1) {
            this.fileList.add(item);
        }
    }

    protected void updateModel(List<IFile> files) {
        try {
            this.setBinding.invoke((Object)this.arguments, files);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateList() {
        try {
            Object result = this.getBinding.invoke((Object)this.arguments, new Object[0]);
            List list = (List)result;
            String[] items = new String[list.size()];
            int index = 0;
            for (Object o : list) {
                if (o instanceof IFile) {
                    items[index++] = this.converter.convert(o).toString();
                    continue;
                }
                throw new RuntimeException(Messages.list_of_files_location_group_no_model_key);
            }
            this.fileList.setItems(items);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface IContentChangeListener {
        public void contentChanged();
    }
}

