/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.CombinationValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.DestinationDialog;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileExtensionValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import oracle.eclipse.tools.webservices.ui.wizards.common.RelativePathStringToIFileConverter;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LabeledIFileSelector
extends LabeledTextSelector {
    private final IFieldValidator[] validators;
    private IPath defaultPath;
    private boolean requireExisting;
    private boolean allowParentEarProjects;

    public LabeledIFileSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, IPath projectRelativeDefault, boolean requireExistingParam, IFieldValidator ... validators) {
        this(label, dialogTitle, dialogMsg, model, modelKey, false, projectRelativeDefault, requireExistingParam, validators);
    }

    public LabeledIFileSelector(String label, String dialogTitle, String dialogMsg, CommonWebServiceAntTaskArguments model, String modelKey, boolean allowParentEarProjectsParam, IPath projectRelativeDefault, boolean requireExistingParam, IFieldValidator ... validatorsParam) {
        super(label, dialogTitle, dialogMsg, model, modelKey);
        this.validators = validatorsParam == null ? new IFieldValidator[]{} : validatorsParam;
        this.defaultPath = projectRelativeDefault;
        this.requireExisting = requireExistingParam;
        this.allowParentEarProjects = allowParentEarProjectsParam;
    }

    private void handleBrowseNew(Text text, String title, String message) {
        IProject project = this.getProject();
        DestinationDialog dialog = new DestinationDialog(text.getShell(), project, title, message, 1, true, this.allowParentEarProjects);
        String currentDest = text.getText().trim();
        if (currentDest.length() > 0) {
            dialog.setOriginalFile((IResource)project.getFile(currentDest));
        }
        if (dialog.open() == 0) {
            IPath result = dialog.getResult();
            if (this.allowParentEarProjects) {
                text.setText(result.toPortableString());
            } else {
                text.setText(result.removeFirstSegments(1).toPortableString());
            }
        }
    }

    private void handleBrowseExisting(Text text, String title, String message) {
        Object result;
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(text.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider){

            protected Control createDialogArea(Composite parent) {
                StringBuilder sb = new StringBuilder();
                IFieldValidator[] iFieldValidatorArray = LabeledIFileSelector.this.validators;
                int n = iFieldValidatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFieldValidator v = iFieldValidatorArray[n2];
                    if (v instanceof FileExtensionValidator) {
                        for (String s : ((FileExtensionValidator)v).getExtensions()) {
                            sb.append(s).append(", ");
                        }
                    }
                    ++n2;
                }
                sb.setLength(sb.length() - 2);
                Composite composite = (Composite)super.createDialogArea(parent);
                new Label(composite, 0).setText(Messages.bind((String)Messages.list_of_files_location_group_filter, (Object)sb));
                return composite;
            }
        };
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)this.getProject());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource r = (IResource)element;
                    if (r.isDerived() || r.getName().startsWith(".")) {
                        return false;
                    }
                    if (r instanceof IFile) {
                        IFieldValidator[] iFieldValidatorArray = LabeledIFileSelector.this.validators;
                        int n = iFieldValidatorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFieldValidator v = iFieldValidatorArray[n2];
                            IStatus s = v.validate(LabeledIFileSelector.this.labelText, r);
                            if (s == IFieldValidator.SKIP_FURTHER_VALIDATION) {
                                return true;
                            }
                            if (!s.isOK()) {
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        dialog.open();
        if (dialog.getReturnCode() == 0 && (result = dialog.getFirstResult()) instanceof IResource) {
            text.setText(((IResource)result).getProjectRelativePath().toPortableString());
        }
    }

    @Override
    protected void handleBrowse(Text text, String title, String message) {
        if (this.requireExisting) {
            this.handleBrowseExisting(text, title, message);
        } else {
            this.handleBrowseNew(text, title, message);
        }
    }

    @Override
    protected String determineDefault() {
        return this.defaultPath != null ? this.defaultPath.toPortableString() : "";
    }

    public void setDefaultPath(IPath projectRelativeDefault) {
        this.defaultPath = projectRelativeDefault;
        this.resetDefaults();
    }

    @Override
    protected UpdateValueStrategy createModelToTargetStrategy() {
        return NeverUpdateStrategy.instance;
    }

    @Override
    protected UpdateValueStrategy createTargetToModelStrategy() {
        boolean optional = false;
        IFieldValidator[] iFieldValidatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            IFieldValidator v = iFieldValidatorArray[n2];
            if (v == IFieldValidator.optional) {
                optional = true;
                break;
            }
            ++n2;
        }
        return new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new RelativePathStringToIFileConverter(this.getModel(), optional, this.allowParentEarProjects)).setAfterConvertValidator((IValidator)new CombinationValidator(this.labelText, this.validators));
    }
}

