/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;

public class JavaWriterContext {
    private IMember selectionMember;
    private final ICompilationUnit compilationUnit;
    private WriterContext writerContext = null;
    private TypeDeclaration typeDeclaration = null;
    private static final int ALL_SEARCH_SCOPE = 15;

    public JavaWriterContext(ICompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    private TypeDeclaration getPrimaryType() {
        return ReaderUtil.getPrimaryType((CompilationUnit)this.getASTRoot());
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public IType getIType() {
        return this.compilationUnit.findPrimaryType();
    }

    public List<IMethod> getPublicITypeMethods() throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = this.getIType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor() && Flags.isPublic((int)method.getFlags())) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public List<IMethod> getAllITypeMethods() throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = this.getIType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor()) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public List<MethodDeclaration> getMethods() {
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methodDeclarationArray = this.getPrimaryType().getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier modifier;
            MethodDeclaration method = methodDeclarationArray[n2];
            if (!method.isConstructor() && (modifier = this.findMethodAccessModifier(method)).isPublic()) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public void initializeEditContext() {
        try {
            this.writerContext = EditUtil.startEdit((ICompilationUnit)this.compilationUnit);
            this.typeDeclaration = ReaderUtil.getPrimaryType((CompilationUnit)this.writerContext.getCompilationUnit());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
    }

    public void internalEndEdit() {
        if (this.hasEditContext()) {
            try {
                EditUtil.endEdit((WriterContext)this.writerContext);
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            }
            catch (BadLocationException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
            }
        }
    }

    public boolean hasEditContext() {
        return this.writerContext != null && this.typeDeclaration != null;
    }

    private CompilationUnit getASTRoot() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(this.compilationUnit);
        parser.setResolveBindings(false);
        CompilationUnit unitAST = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        return unitAST;
    }

    private Modifier findMethodAccessModifier(MethodDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isModifier()) continue;
            Modifier.ModifierKeyword modifierKeyword = ((Modifier)modifier).getKeyword();
            assert (modifierKeyword != null) : "ModifierKeyword was not resolved. Can this happen in normal operation?";
            switch (modifierKeyword.toFlagValue()) {
                case 2: {
                    return (Modifier)modifier;
                }
                case 4: {
                    return (Modifier)modifier;
                }
                case 1: {
                    return (Modifier)modifier;
                }
            }
        }
        return null;
    }

    public WriterContext getWriterContext() {
        return this.writerContext;
    }

    public List<IMember> javaTypeAllSearchScope(String type) {
        return this.javaSearchScope(type, 15, 0, 1, 10);
    }

    public List<IMember> javaTypeImplementorApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 0, 1, 10);
    }

    public List<IMember> javaTypeClassInterfaceApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 10, 0, 10);
    }

    private List<IMember> javaSearchScope(String type, int searchScope, int searchFor, int limitTo, int matchRule) {
        final ArrayList<IMember> typesOfReferences = new ArrayList<IMember>();
        if (type == null) {
            return typesOfReferences;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.compilationUnit.getJavaProject()}, (int)searchScope);
        SearchPattern pattern = SearchPattern.createPattern((String)type, (int)searchFor, (int)limitTo, (int)matchRule);
        SearchEngine engine = new SearchEngine();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (!(element instanceof IMember)) {
                    return;
                }
                typesOfReferences.add((IMember)element);
            }
        };
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return typesOfReferences;
    }

    public IMember getSelectionMember() {
        return this.selectionMember;
    }

    public void setSelectionMember(IMember selectionMember) {
        this.selectionMember = selectionMember;
    }
}

