/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileExtensionValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.XmlBindingsValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;

public interface IFieldValidator {
    public static final IStatus SKIP_FURTHER_VALIDATION = new Status(0, "oracle.eclipse.tools.webservices.ui", "SKIP");
    public static final FileExtensionValidator jarFile = new FileExtensionValidator("jar", "zip");
    public static final FileExtensionValidator xmlFile = new FileExtensionValidator("xml");
    public static final FileExtensionValidator xmlCatalogFile = new FileExtensionValidator("xml", "cat", "catalog", "xmlcatalog");
    public static final FileExtensionValidator xmlJaxbBindings = new XmlBindingsValidator("oracle.eclipse.tools.webservices.jaxbBindings");
    public static final FileExtensionValidator xmlBindings = new XmlBindingsValidator("oracle.eclipse.tools.webservices.jaxbBindings", "oracle.eclipse.tools.webservices.jaxWSBindings");
    public static final FileExtensionValidator schemaFile = new FileExtensionValidator("xsd");
    public static final IFieldValidator optional = new FieldValidator(){

        @Override
        public IStatus validate(String fieldname, Object value) {
            if (value == null || "".equals(String.valueOf(value))) {
                return SKIP_FURTHER_VALIDATION;
            }
            return Status.OK_STATUS;
        }
    };
    public static final IFieldValidator packageName = new FieldValidator(){

        @Override
        public IStatus validate(String fieldname, Object value) {
            if (!(value instanceof String)) {
                return this.error(Messages.ifield_validator_pkg_name_read);
            }
            String s = (String)value;
            if (s.length() == 0) {
                return Status.OK_STATUS;
            }
            IStatus status = JavaConventions.validatePackageName((String)s, (String)"1.5", (String)"1.5");
            return status;
        }
    };
    public static final IFieldValidator directory = new FieldValidator(){

        @Override
        public IStatus validate(String fieldname, Object value) {
            if (!(value instanceof IContainer)) {
                return this.error(Messages.ifield_validator_non_empty_dir_name);
            }
            IContainer dir = (IContainer)value;
            if (dir.exists()) {
                if (dir.getType() != 2) {
                    return this.error(Messages.ifield_validator_must_be_dir);
                }
                if (dir.isDerived()) {
                    return this.error(Messages.ifield_validator_no_derived);
                }
            }
            return Status.OK_STATUS;
        }
    };
    public static final IFieldValidator file = new FieldValidator(){

        @Override
        public IStatus validate(String fieldname, Object value) {
            if (!(value instanceof IFile)) {
                return this.error(Messages.ifield_validator_non_empty_filename);
            }
            IFile file = (IFile)value;
            if (file.exists()) {
                if (file.getType() == 2) {
                    return this.error(Messages.ifield_validator_no_dir);
                }
                if (file.isDerived()) {
                    return this.error(Messages.ifield_validator_no_derived);
                }
            }
            return Status.OK_STATUS;
        }
    };
    public static final IFieldValidator srcDirectory = new FieldValidator(){

        @Override
        public IStatus validate(String fieldname, Object value) {
            if (value instanceof IPackageFragmentRoot) {
                return Status.OK_STATUS;
            }
            return this.error(Messages.ifield_validator_source_dir);
        }
    };

    public IStatus validate(String var1, Object var2);

    public static abstract class FieldValidator
    implements IFieldValidator {
        protected IStatus error(String msg) {
            return new Status(4, "oracle.eclipse.tools.webservices.ui", msg);
        }
    }
}

