/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.FileValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.ide.IDE;

public class ContentTypeValidator
extends FileValidator {
    private String[] contentTypeIDs;
    private Set<String> extensions = new HashSet<String>();

    public ContentTypeValidator(String ... contentTypeIDs) {
        if (contentTypeIDs == null) {
            this.contentTypeIDs = new String[0];
        } else {
            this.contentTypeIDs = new String[contentTypeIDs.length];
            System.arraycopy(contentTypeIDs, 0, this.contentTypeIDs, 0, contentTypeIDs.length);
        }
        String[] stringArray = this.contentTypeIDs;
        int n = this.contentTypeIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fileExtSpec;
            String id = stringArray[n2];
            IContentType contentType = Platform.getContentTypeManager().getContentType(id);
            String[] stringArray2 = fileExtSpec = contentType.getFileSpecs(8);
            int n3 = fileExtSpec.length;
            int n4 = 0;
            while (n4 < n3) {
                String extension = stringArray2[n4];
                this.extensions.add(extension);
                ++n4;
            }
            ++n2;
        }
    }

    public List<String> getIDs() {
        return Collections.unmodifiableList(Arrays.asList(this.contentTypeIDs));
    }

    public Set<String> getFileExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    @Override
    protected IStatus validate(IFile file) {
        String[] stringArray = this.contentTypeIDs;
        int n = this.contentTypeIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String contentTypeId = stringArray[n2];
            IContentType contentType = IDE.getContentType((IFile)file);
            if (contentType != null && contentType.getId().equals(contentTypeId)) {
                return super.validate(file);
            }
            ++n2;
        }
        return this.error(Messages.bind((String)Messages.file_extension_validator_only_these_extensions, (Object)file.getName(), Arrays.asList(this.contentTypeIDs)));
    }
}

