/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.services;

import oracle.eclipse.tools.webservices.ui.Messages;
import org.eclipse.jdt.core.IType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ITypeValidationService
extends ValidationService {
    protected void initValidationService() {
        Value property = (Value)this.context(Value.class);
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)property.service(JavaTypeConstraintService.class);
        if (javaTypeConstraintService != null) {
            javaTypeConstraintService.attach(new Listener(){

                public void handle(Event event) {
                    ITypeValidationService.this.refresh();
                }
            });
        }
    }

    protected Status compute() {
        JavaType type;
        ReferenceValue value = (ReferenceValue)this.context(ReferenceValue.of(JavaTypeName.class, JavaType.class));
        String val = value.text(false);
        String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
        if (val != null && (type = (JavaType)value.resolve()) != null) {
            try {
                IType t = (IType)type.artifact();
                if (t.getPackageFragment().getKind() != 1) {
                    String msg = Messages.bind((String)Messages.type_validation_service_not_in_source, (Object)val, (Object)label);
                    return Status.createErrorStatus((String)msg);
                }
            }
            catch (Exception e) {
                return Status.createErrorStatus((Throwable)e);
            }
        }
        return Status.createOkStatus();
    }
}

