/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.internal;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;

public class ClientClassListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        Object obj;
        IClientProxyModel element = (IClientProxyModel)event.property().element().nearest(IClientProxyModel.class);
        if (element.getClientClass().content() == null) {
            return;
        }
        ClientProxyModelResource clientProxyModelResource = (ClientProxyModelResource)element.resource();
        IStructuredSelection selection = clientProxyModelResource.getSelection();
        String clientClassName = ((JavaTypeName)element.getClientClass().content()).qualified();
        IFile file = null;
        if (selection != null && (obj = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)obj;
            file = (IFile)a.getAdapter(IFile.class);
        }
        if (file != null && file.exists()) {
            IJavaElement elem = JavaCore.create(file);
            if (elem instanceof ICompilationUnit) {
                try {
                    IType t;
                    IResource resource;
                    JavaType clientClassType;
                    String sClassName;
                    IType[] types = ((ICompilationUnit)elem).getTypes();
                    IType mainType = ((ICompilationUnit)elem).findPrimaryType();
                    if (types != null && types.length > 0 && mainType == null) {
                        mainType = types[0];
                    }
                    if (!(sClassName = mainType.getFullyQualifiedName()).equals(clientClassName) && (clientClassType = (JavaType)element.getClientClass().resolve()) != null && (resource = (t = (IType)clientClassType.artifact()).getResource()) != null) {
                        clientProxyModelResource.setSelection((IStructuredSelection)new StructuredSelection((Object)resource));
                        clientProxyModelResource.initializeClass(t.getCompilationUnit(), file);
                    }
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
            }
        } else {
            IType clientClassType = (IType)((JavaType)element.getClientClass().resolve()).artifact();
            if (clientClassType != null) {
                IResource resource = clientClassType.getResource();
                clientProxyModelResource.setSelection((IStructuredSelection)new StructuredSelection((Object)resource));
                clientProxyModelResource.initializeClass(clientClassType.getCompilationUnit(), (IFile)resource);
            }
        }
    }
}

