/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.actions;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class MethodCreateActionHandler
extends PropertyEditorActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        final IClientProxyModel element = (IClientProxyModel)this.getModelElement();
        ValueProperty property = this.property().definition();
        FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                MethodCreateActionHandler.this.refreshEnablementState();
            }
        };
        element.attach((Listener)listener, property.name());
        element.getClientClass().attach((Listener)listener);
        this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)listener, property){
            private final /* synthetic */ Listener val$listener;
            private final /* synthetic */ ValueProperty val$property;
            {
                this.val$listener = listener;
                this.val$property = valueProperty;
            }

            protected void handleTypedEvent(DisposeEvent event) {
                element.detach(this.val$listener, this.val$property.name());
            }
        });
    }

    protected Object run(Presentation context) {
        InputDialog dialog;
        IClientProxyModel element = (IClientProxyModel)this.getModelElement();
        IProject proj = (IProject)element.adapt(IProject.class);
        IJavaProject jproj = JavaCore.create((IProject)proj);
        Value<?> methodNameValue = this.property();
        String iName = null;
        if (!methodNameValue.malformed()) {
            iName = (String)methodNameValue.content();
        }
        if ((dialog = new InputDialog(((SwtPresentation)context).shell(), Messages.method_create_dialog_title, Messages.method_create_dialog_description, iName, this.createMethodNameInputValidator(jproj))).open() == 0) {
            final String methodName = dialog.getValue();
            final JavaType type = (JavaType)element.getClientClass().resolve();
            if (type == null || methodName == null) {
                return null;
            }
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 6);
                    StringBuilder buf = new StringBuilder();
                    buf.append("public ");
                    buf.append("void");
                    buf.append(' ');
                    buf.append(methodName);
                    buf.append("()\n{\n}\n");
                    monitor.worked(1);
                    try {
                        IType iType = (IType)type.artifact();
                        ICompilationUnit icu = iType.getCompilationUnit();
                        WriterContext context = EditUtil.startEdit((ICompilationUnit)icu);
                        monitor.worked(1);
                        TypeDeclaration tD = ReaderUtil.getPrimaryType((CompilationUnit)context.getCompilationUnit());
                        WriterUtil.insertMethod((TypeDeclaration)tD, (String)buf.toString(), (WriterContext)context);
                        monitor.worked(1);
                        EditUtil.endEdit((WriterContext)context);
                        monitor.worked(1);
                        IEditorPart editor = JavaUI.openInEditor((IJavaElement)icu);
                        IWorkbenchPartSite site = editor.getSite();
                        monitor.worked(1);
                        FormatAllAction formatAllAction = new FormatAllAction((IWorkbenchSite)site);
                        formatAllAction.runOnMultiple(new ICompilationUnit[]{icu});
                        monitor.worked(1);
                        editor.doSave(null);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    }
                    catch (BadLocationException e) {
                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(((SwtPresentation)context).shell()).run(false, false, op);
            }
            catch (InvocationTargetException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            catch (InterruptedException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            if (methodName != null) {
                this.property().write((Object)(String.valueOf(methodName) + "()"));
            }
        }
        return null;
    }

    private IInputValidator createMethodNameInputValidator(final IJavaProject jproj) {
        IInputValidator validator = new IInputValidator(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public String isValid(String name) {
                IStatus status = JavaConventions.validateMethodName((String)name, (String)MethodCreateActionHandler.getSourceComplianceLevels((IJavaElement)jproj)[0], (String)MethodCreateActionHandler.getSourceComplianceLevels((IJavaElement)jproj)[1]);
                if (!status.isOK()) {
                    return status.getMessage();
                }
                IClientProxyModel element = (IClientProxyModel)MethodCreateActionHandler.this.getModelElement();
                JavaType type = (JavaType)element.getClientClass().resolve();
                try {
                    IMethod[] iMethodArray = ((IType)type.artifact()).getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return null;
                        }
                        IMethod method = iMethodArray[n2];
                        if (method.getElementName() != null && name.toLowerCase().equals(method.getElementName().toLowerCase())) {
                            return "Already Exists";
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return null;
            }
        };
        return validator;
    }

    public Value<?> property() {
        return (Value)super.property();
    }

    private static String[] getSourceComplianceLevels(IJavaElement context) {
        IJavaProject javaProject;
        if (context != null && (javaProject = context.getJavaProject()) != null) {
            return new String[]{javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)};
        }
        return new String[]{JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance")};
    }

    protected boolean computeEnablementState() {
        boolean enabled = super.computeEnablementState();
        if (enabled) {
            IClientProxyModel element = (IClientProxyModel)this.getModelElement();
            JavaType type = (JavaType)element.getClientClass().resolve();
            return type != null;
        }
        return enabled;
    }
}

