/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.ASTInvocationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.IDocument;

public class ClientWriterContext
extends ASTInvocationContext {
    private static final int ALL_SEARCH_SCOPE = 15;
    private HashMap<String, IMember> memberIdentityMap = new HashMap();
    private HashMap<String, IMember> modelSelectionIdentityMap = new HashMap();

    public ClientWriterContext(ICompilationUnit compilationUnit, IDocument document) {
        super(compilationUnit, document, 0, 0);
    }

    public boolean hasValues() {
        return !this.memberIdentityMap.isEmpty();
    }

    public void add(String index, IMember value) {
        this.memberIdentityMap.put(index, value);
    }

    public IMember getMember(String key) {
        return this.memberIdentityMap.get(key);
    }

    public void setMemberModelSelection(String key, String property) {
        IMember member = this.getMember(key);
        if (member != null) {
            this.setSelectionMember(property, member);
        }
    }

    public String[] getKeySetArray() {
        Set<String> set = this.memberIdentityMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public IMember getSelectionMember(String property) {
        return this.modelSelectionIdentityMap.get(property);
    }

    public void setSelectionMember(String property, IMember selectionMember) {
        this.modelSelectionIdentityMap.put(property, selectionMember);
    }

    private TypeDeclaration getPrimaryType() {
        return ReaderUtil.getPrimaryType((CompilationUnit)this.getASTRoot());
    }

    public IType getIType() {
        return this.getCompilationUnit().findPrimaryType();
    }

    public List<IMethod> getPublicITypeMethods() throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = this.getIType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor() && Flags.isPublic((int)method.getFlags())) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public List<IMethod> getAllITypeMethods() throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = this.getIType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor()) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public List<MethodDeclaration> getMethods() {
        ArrayList<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methodDeclarationArray = this.getPrimaryType().getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier modifier;
            MethodDeclaration method = methodDeclarationArray[n2];
            if (!method.isConstructor() && (modifier = this.findMethodAccessModifier(method)).isPublic()) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    private Modifier findMethodAccessModifier(MethodDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isModifier()) continue;
            Modifier.ModifierKeyword modifierKeyword = ((Modifier)modifier).getKeyword();
            assert (modifierKeyword != null) : "ModifierKeyword was not resolved. Can this happen in normal operation?";
            switch (modifierKeyword.toFlagValue()) {
                case 2: {
                    return (Modifier)modifier;
                }
                case 4: {
                    return (Modifier)modifier;
                }
                case 1: {
                    return (Modifier)modifier;
                }
            }
        }
        return null;
    }

    public List<IMember> javaTypeAllSearchScope(String type) {
        return this.javaSearchScope(type, 15, 0, 1, 10);
    }

    public List<IMember> javaTypeImplementorApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 0, 1, 10);
    }

    public List<IMember> javaTypeClassInterfaceApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 10, 0, 10);
    }

    private List<IMember> javaSearchScope(String type, int searchScope, int searchFor, int limitTo, int matchRule) {
        final ArrayList<IMember> typesOfReferences = new ArrayList<IMember>();
        if (type == null) {
            return typesOfReferences;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getCompilationUnit().getJavaProject()}, (int)searchScope);
        SearchPattern pattern = SearchPattern.createPattern((String)type, (int)searchFor, (int)limitTo, (int)matchRule);
        SearchEngine engine = new SearchEngine();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (!(element instanceof IMember)) {
                    return;
                }
                typesOfReferences.add((IMember)element);
            }
        };
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return typesOfReferences;
    }
}

