/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.model.WsdlParseFaildedException;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceJavaContext;
import oracle.eclipse.tools.webservices.ui.policy.model.WsdlInfo;
import oracle.eclipse.tools.webservices.util.JarFileHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ClientServiceWSDLInfo {
    private static final String JAR_FILE_EXT = "jar";
    private final IMember member;
    private final IJavaProject project;

    public ClientServiceWSDLInfo(IMember member, IJavaProject project) {
        this.member = member;
        this.project = project;
    }

    public WsdlInfo findWsdlDefinition(String serviceName, String portName) throws IOException, WsdlParseFaildedException, URISyntaxException {
        if (serviceName == null) {
            return null;
        }
        IPath path = this.member.getPath();
        String fileExt = path.getFileExtension();
        if (fileExt.contains(JAR_FILE_EXT)) {
            String[] entries;
            new JarFileHandler(path.toFile(), this.project.getProject());
            String[] stringArray = entries = JarFileHandler.getEntryNames((String)path.toOSString());
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (entry.contains(".wsdl")) {
                    Iterator iterator;
                    Collection portNames;
                    LightweightWsdlModel lwwM = new LightweightWsdlModel(this.createJarUrl(new JarFile(path.toFile()), entry).toURI());
                    Map map = lwwM.getPorts();
                    Map prefix = lwwM.getServicePrefix();
                    String targetNamespace = lwwM.getTargetNamespace();
                    if (map.containsKey(serviceName) && (portNames = (Collection)map.get(serviceName)).size() == 1 && (iterator = portNames.iterator()).hasNext()) {
                        String port = (String)iterator.next();
                        InputStream wsdlStream = JarFileHandler.getInputStream((String)path.toOSString(), (String)entry);
                        String wsdl = FileUtil.readFile((InputStream)wsdlStream);
                        return new WsdlInfo(wsdl, serviceName, targetNamespace, (String)prefix.get(serviceName), port, lwwM.hasPolicies());
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public void findWebServiceClientStuff() throws JavaModelException {
        IType wsClientType = WebServiceJavaContext.findAnnotatedType("javax.xml.ws.WebServiceClient", this.member);
        String cfr_ignored_0 = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebServiceClient", "name", (IAnnotatable)wsClientType);
        String cfr_ignored_1 = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebServiceClient", "targetNamespace", (IAnnotatable)wsClientType);
        String cfr_ignored_2 = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebServiceClient", "wsdlLocation", (IAnnotatable)wsClientType);
    }

    public URL createJarUrl(JarFile jarFile, String jarEntryName) throws MalformedURLException {
        String fixedJarFileName = jarFile.getName().replace("\\", "/");
        return this.createJarUrl(fixedJarFileName, jarEntryName != null ? jarEntryName : "");
    }

    public URL createJarUrl(String filePath, String jarEntryName) throws MalformedURLException {
        String urlString = String.format("jar:file:///%s!/%s", filePath, jarEntryName);
        return new URL(urlString);
    }
}

