/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model;

import java.util.Map;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientWriterContext;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;

public class ClientProxyUpdateExisting {
    public static Status execute(IClientProxyModel cpModel, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Messages.generate_jws_from_java_execute_task_name, 3);
        try {
            try {
                String sPort;
                ClientProxyModelResource resource = (ClientProxyModelResource)cpModel.resource();
                ClientWriterContext clientCtx = (ClientWriterContext)resource.getInfo().getContext();
                if (clientCtx == null) {
                    IType clientClassType = (IType)((JavaType)cpModel.getClientClass().resolve()).artifact();
                    if (clientClassType != null) {
                        IResource iResource = clientClassType.getResource();
                        resource.setSelection((IStructuredSelection)new StructuredSelection((Object)iResource));
                        resource.initializeClass(clientClassType.getCompilationUnit(), (IFile)iResource);
                    }
                    clientCtx = (ClientWriterContext)resource.getInfo().getContext();
                }
                clientCtx.initializeEditContext();
                IMethod method = (IMethod)cpModel.getTargetMethod().resolve();
                if (method != null) {
                    clientCtx.setSelectionMember(IClientProxyModel.PROP_TARGET_METHOD.name(), (IMember)method);
                }
                if ((sPort = (String)cpModel.getPortName().content()) != null) {
                    Map<String, IMember> map = resource.getPortMemberMap();
                    IMember member = map.get(sPort);
                    clientCtx.setSelectionMember(IClientProxyModel.PROP_PORT_NAME.name(), member);
                }
            }
            catch (Exception e) {
                String message = Messages.bind((String)Messages.generate_jws_from_java_execute_task_error, (Object)e.getLocalizedMessage());
                Status status = Status.createErrorStatus((String)message);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }
}

