/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientJavaInfo;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientWriterContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;

public class ClientProxyModelResource
extends Resource {
    private final ElementType type;
    private ClientJavaInfo info;
    private Map<String, IMethod> methodMap = Collections.emptyMap();
    private Map<String, IMember> portMemberMap = Collections.emptyMap();
    private IProject project;

    public ClientProxyModelResource(ElementType type, ClientJavaInfo info, IProject project) {
        this(type, null, info, project);
    }

    public ClientProxyModelResource(ElementType type, ClientProxyModelResource parent, ClientJavaInfo info, IProject project) {
        super((Resource)parent);
        this.type = type;
        this.info = info;
        this.project = project;
    }

    public ElementType type() {
        return this.type;
    }

    public ClientProxyModelResource parent() {
        return (ClientProxyModelResource)super.parent();
    }

    public ClientProxyModelResource root() {
        return (ClientProxyModelResource)super.root();
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        Object binding = null;
        if (p instanceof ValueProperty) {
            binding = new ValuePropertyBinding(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        } else if (p instanceof ImpliedElementProperty) {
            binding = new ElementPropertyBinding(property){
                private final ClientProxyModelResource element;
                {
                    this.element = new ClientProxyModelResource(property.definition().getType(), ClientProxyModelResource.this, ClientProxyModelResource.this.info, ClientProxyModelResource.this.project);
                }

                public ElementType type(Resource resource) {
                    return ((ClientProxyModelResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }
            };
        } else if (p instanceof ElementProperty) {
            binding = new ElementPropertyBinding(){
                private ClientProxyModelResource element;

                public ElementType type(Resource resource) {
                    return ((ClientProxyModelResource)resource).type();
                }

                public Resource read() {
                    return this.element;
                }

                public Resource create(ElementType type) {
                    this.element = new ClientProxyModelResource(type, ClientProxyModelResource.this, ClientProxyModelResource.this.info, ClientProxyModelResource.this.project);
                    return this.element;
                }

                public void remove() {
                    this.element = null;
                }
            };
        } else if (p instanceof ListProperty) {
            binding = new ListPropertyBinding(){
                private final List<Resource> list = new ArrayList<Resource>();

                public ElementType type(Resource resource) {
                    return ((ClientProxyModelResource)resource).type();
                }

                public List<Resource> read() {
                    return this.list;
                }

                public Resource insert(ElementType type, int position) {
                    ClientProxyModelResource resource = new ClientProxyModelResource(type, ClientProxyModelResource.this, ClientProxyModelResource.this.info, ClientProxyModelResource.this.project);
                    this.list.add(position, resource);
                    return resource;
                }

                public void move(Resource resource, int position) {
                    int oldPosition = this.list.indexOf(resource);
                    if (position < oldPosition) {
                        this.list.remove(oldPosition);
                        this.list.add(position, resource);
                    } else {
                        this.list.add(position, resource);
                        this.list.remove(oldPosition);
                    }
                }

                public void remove(Resource resource) {
                    this.list.remove(resource);
                }
            };
        }
        return binding;
    }

    public ClientJavaInfo getInfo() {
        return this.info;
    }

    public void setInfo(ClientJavaInfo info) {
        this.info = info;
    }

    public Map<String, IMethod> getMethodMap() {
        return this.methodMap;
    }

    public void setMethodMap(Map<String, IMethod> methodMap) {
        this.methodMap = methodMap;
    }

    public Map<String, IMember> getPortMemberMap() {
        return this.portMemberMap;
    }

    public void setPortMemberMap(Map<String, IMember> memberMap) {
        this.portMemberMap = memberMap;
    }

    public IStructuredSelection getSelection() {
        return this.info.getSelection();
    }

    public void setSelection(IStructuredSelection selection) {
        this.info.setSelection(selection);
    }

    public void initializeClass(ICompilationUnit unit, IFile file) {
        ClientWriterContext ctx = new ClientWriterContext(unit, null);
        this.info.setSourceFile(file);
        this.info.setSelection((IStructuredSelection)new StructuredSelection((Object)file));
        this.info.setContext(ctx);
    }

    public String methodSignature(IMethod method) throws JavaModelException {
        return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)false);
    }

    public <A> A adapt(Class<A> adapterType) {
        IAdaptable a;
        IResource resource;
        IProject project;
        Object obj;
        IStructuredSelection selection;
        if (adapterType == IProject.class && (selection = this.info.getSelection()) != null && (obj = selection.getFirstElement()) instanceof IAdaptable && (project = (resource = (IResource)(a = (IAdaptable)obj).getAdapter(IResource.class)).getProject()) != null) {
            return adapterType.cast(project);
        }
        return (A)super.adapt(adapterType);
    }
}

