/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.credential.WeblogicCredentialConfig;
import oracle.eclipse.tools.weblogic.credential.model.ICredentialConfiguration;
import oracle.eclipse.tools.weblogic.credential.model.ICredentialInfo;
import oracle.eclipse.tools.weblogic.ui.credential.CredentialPreferencePage;
import oracle.eclipse.tools.webservices.WebServiceClient;
import oracle.eclipse.tools.webservices.ant.WsdlBasedAntTaskArguments;
import oracle.eclipse.tools.webservices.clientgen.ClientGenArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.WebServiceProjectWsdlLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.WsdlUrlChangedListener;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlLocationPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WsdlLocationPageWithRemoteChoice
extends WsdlLocationPage {
    private ClientGenArguments arguments;
    private WsdlUrlChangedListener wsdlUrlChangedListener;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite remoteComposite;
    private Button local;
    private Text urlText;
    private Combo projectsCombo;
    private Label credentialLabel;
    private Combo httpsCredentialCombo;
    private SelectionAdapter projectsComboSelectionListener;
    private Hyperlink credentailPrefLink;
    static Browser browser;
    static String[] urls;
    static String[] titles;
    static int index;

    public WsdlLocationPageWithRemoteChoice(WsdlBasedAntTaskArguments args, WebServiceProjectWsdlLocatorContentProvider wsdlLocatorContentProvider, IFileSelectionChangedListener wsdlSelectionChangedListener, WsdlUrlChangedListener wsdlUrlChangedListener, ClientGenArguments arguments, String description, String helpContextId) {
        super(args, wsdlLocatorContentProvider, wsdlSelectionChangedListener, description, helpContextId);
        this.wsdlUrlChangedListener = wsdlUrlChangedListener;
        this.arguments = arguments;
    }

    @Override
    protected void createLocalLocationComposite(Composite main) {
        this.createLocalOrRemoteGroup(main);
        new Label(main, 258).setLayoutData((Object)new GridData(768));
        this.stackComposite = new Composite(main, 0);
        GridData data = new GridData(1808);
        data.heightHint = 450;
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        this.stackComposite.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        super.createLocalLocationComposite(this.stackComposite);
        this.createRemoteLocationComposite(this.stackComposite);
        this.updateTopControl();
    }

    protected void createLocalOrRemoteGroup(Composite main) {
        Composite parent = new Composite(main, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        GridData gd = new GridData();
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gd);
        Label lbl = new Label(parent, 0);
        lbl.setText(Messages.wsdl_location_page_with_remote_choice_wsdl_location);
        this.local = new Button(parent, 16);
        this.local.setText(Messages.wsdl_location_page_with_remote_choice_local);
        this.local.setSelection(true);
        this.local.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsdlLocationPageWithRemoteChoice.this.updateTopControl();
            }
        });
        Button remote = new Button(parent, 16);
        remote.setText(Messages.wsdl_location_page_with_remote_choice_remote);
        remote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsdlLocationPageWithRemoteChoice.this.updateTopControl();
            }
        });
    }

    protected void createRemoteLocationComposite(Composite main) {
        this.remoteComposite = new Composite(main, 0);
        GridLayout gl = new GridLayout(1, false);
        this.remoteComposite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        this.remoteComposite.setLayoutData((Object)gd);
        new Label(this.remoteComposite, 0).setText(Messages.wsdl_location_page_with_remote_choice_dest_project);
        this.projectsCombo = new Combo(this.remoteComposite, 12);
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WebServiceClient.isWebServiceClientsProject((IProject)project)) {
                this.projectsCombo.add(project.getName());
            }
            ++n2;
        }
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.projectsCombo.setLayoutData((Object)gd);
        this.projectsComboSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = WsdlLocationPageWithRemoteChoice.this.projectsCombo.getSelectionIndex();
                if (index >= 0) {
                    WsdlLocationPageWithRemoteChoice.this.arguments.setProject(root.getProject(WsdlLocationPageWithRemoteChoice.this.projectsCombo.getItem(index)));
                }
                WsdlLocationPageWithRemoteChoice.this.updateCredentialList();
                URL url = WsdlLocationPageWithRemoteChoice.this.arguments.getWsdlURL();
                if (url != null) {
                    boolean valid = WsdlLocationPageWithRemoteChoice.this.wsdlUrlChangedListener.wsdlSelectionChanged(url);
                    WsdlLocationPageWithRemoteChoice.this.setPageComplete(valid);
                }
            }
        };
        this.projectsCombo.addSelectionListener((SelectionListener)this.projectsComboSelectionListener);
        Group wsdlBrowseGroup = new Group(this.remoteComposite, 32);
        wsdlBrowseGroup.setText("WSDL Browser");
        wsdlBrowseGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.minimumHeight = -1;
        wsdlBrowseGroup.setLayoutData((Object)gd);
        Label dlgLabel = new Label((Composite)wsdlBrowseGroup, 0);
        dlgLabel.setText(Messages.wsdl_location_page_with_remote_choice_url);
        dlgLabel.setLayoutData((Object)new GridData(1, 0, false, false));
        this.urlText = new Text((Composite)wsdlBrowseGroup, 2052);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsdlLocationPageWithRemoteChoice.this.arguments.setWsdlModel(null);
                boolean isHttps = WsdlLocationPageWithRemoteChoice.this.urlText.getText().startsWith("https://");
                WsdlLocationPageWithRemoteChoice.this.credentailPrefLink.setVisible(isHttps);
                WsdlLocationPageWithRemoteChoice.this.httpsCredentialCombo.setVisible(isHttps);
                WsdlLocationPageWithRemoteChoice.this.credentialLabel.setVisible(isHttps);
                WsdlLocationPageWithRemoteChoice.this.setPageComplete(false);
            }
        });
        this.urlText.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        new Label((Composite)wsdlBrowseGroup, 0);
        Button validateWsdl = new Button((Composite)wsdlBrowseGroup, 0);
        validateWsdl.setText(Messages.wsdl_location_page_with_remote_choice_validate_wsdl);
        validateWsdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URL url;
                try {
                    url = new URL(WsdlLocationPageWithRemoteChoice.this.urlText.getText());
                    if (url.getProtocol().equals("https")) {
                        ICredentialInfo credential;
                        Path path;
                        ICredentialConfiguration credentialCfg = WeblogicCredentialConfig.getCredentialConfiguration();
                        int n = WsdlLocationPageWithRemoteChoice.this.httpsCredentialCombo.getSelectionIndex();
                        if (n >= 0 && (path = (Path)(credential = (ICredentialInfo)credentialCfg.getCredentialInfo().get(n)).getHttpsClientTrustKeystore().content()) != null) {
                            System.setProperty("javax.net.ssl.trustStore", path.toOSString());
                            WebLogicServerUtil.setSSLKeyStoreAndHostnameVerifier((String)path.toPortableString(), (String)url.getHost());
                        }
                    }
                }
                catch (MalformedURLException ex) {
                    DialogService.showErrorDialog((String)Messages.bind((String)Messages.wsdl_location_page_with_remote_choice_not_valid_url, (Object)WsdlLocationPageWithRemoteChoice.this.urlText.getText()), (Throwable)ex);
                    WsdlLocationPageWithRemoteChoice.this.setPageComplete(false);
                    return;
                }
                int index = WsdlLocationPageWithRemoteChoice.this.projectsCombo.getSelectionIndex();
                if (index >= 0) {
                    WsdlLocationPageWithRemoteChoice.this.arguments.setProject(root.getProject(WsdlLocationPageWithRemoteChoice.this.projectsCombo.getItem(index)));
                }
                browser.setUrl(url.toString());
                boolean validWsdl = WsdlLocationPageWithRemoteChoice.this.wsdlUrlChangedListener.wsdlSelectionChanged(url);
                WsdlLocationPageWithRemoteChoice.this.setPageComplete(validWsdl);
            }
        });
        Label httpLabel = new Label((Composite)wsdlBrowseGroup, 0);
        httpLabel.setText("&HTTP Response:");
        httpLabel.setLayoutData((Object)new GridData(1, 0, false, false));
        Composite comp = new Composite((Composite)wsdlBrowseGroup, 0);
        gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        comp.setLayout((Layout)new FillLayout());
        SashForm form = new SashForm(comp, 256);
        form.setLayout((Layout)new FillLayout());
        try {
            browser = new Browser((Composite)form, 0);
        }
        catch (SWTError sWTError) {
            MessageBox messageBox = new MessageBox(wsdlBrowseGroup.getShell(), 33);
            messageBox.setMessage("Closing application. The Browser could not be initialized.");
            messageBox.setText("Fatal error - application terminated");
            messageBox.open();
            System.exit(-1);
        }
        this.credentialLabel = new Label(this.remoteComposite, 0);
        this.credentialLabel.setText(Messages.wsdl_location_page_with_remote_choice_credentials);
        this.credentialLabel.setVisible(false);
        this.httpsCredentialCombo = new Combo(this.remoteComposite, 12);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.httpsCredentialCombo.setLayoutData((Object)gd);
        this.httpsCredentialCombo.setVisible(false);
        this.httpsCredentialCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int n = WsdlLocationPageWithRemoteChoice.this.httpsCredentialCombo.getSelectionIndex();
                if (n >= 0) {
                    try {
                        ICredentialConfiguration credentialCfg = WeblogicCredentialConfig.getCredentialConfiguration();
                        ICredentialInfo credential = (ICredentialInfo)credentialCfg.getCredentialInfo().get(n);
                        Path path = (Path)credential.getHttpsClientTrustKeystore().content();
                        WsdlLocationPageWithRemoteChoice.this.arguments.setTrustStore(path.toPortableString());
                    }
                    catch (Exception exception) {}
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.remoteComposite, 0).setText("");
        new Label(this.remoteComposite, 0).setText("");
        this.credentailPrefLink = new Hyperlink(this.remoteComposite, 0);
        this.credentailPrefLink.setForeground(new Color((Device)Display.getDefault(), 0, 0, 255));
        this.credentailPrefLink.setText(Messages.wsdl_location_page_with_remote_choice_cfg_keystore);
        this.credentailPrefLink.setUnderlined(true);
        this.credentailPrefLink.setVisible(false);
        this.credentailPrefLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PreferenceManager prefManager = new PreferenceManager();
                CredentialPreferencePage page = new CredentialPreferencePage();
                page.init(null);
                page.setTitle(Messages.wsdl_location_page_with_remote_https_dlg);
                PreferenceNode node = new PreferenceNode("oracle.eclipse.tools.weblogic.ui.credential", (IPreferencePage)page);
                prefManager.addToRoot((IPreferenceNode)node);
                Shell shell = Display.getDefault().getActiveShell();
                final PreferenceDialog dialog = new PreferenceDialog(shell, prefManager);
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialog.create();
                        dialog.open();
                        WsdlLocationPageWithRemoteChoice.this.updateCredentialList();
                    }
                });
            }
        });
        this.updateCredentialList();
    }

    private void updateCredentialList() {
        ICredentialConfiguration credentialCfg = WeblogicCredentialConfig.getCredentialConfiguration();
        if (credentialCfg == null) {
            return;
        }
        ElementList list = credentialCfg.getCredentialInfo();
        this.httpsCredentialCombo.removeAll();
        for (ICredentialInfo c : list) {
            this.httpsCredentialCombo.add((String)c.getName().content());
            this.httpsCredentialCombo.setData((Object)c);
        }
        if (list.size() > 0) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String projName = this.projectsCombo.getText();
            if (projName == null || projName.length() == 0) {
                return;
            }
            IProject proj = root.getProject(projName);
            IProjectFacetVersion fv = FacetedProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"wls.web");
            if (fv != null) {
                int n = 0;
                for (ICredentialInfo c : list) {
                    String rtid = (String)c.getRuntimeId().content();
                    if (rtid.indexOf(fv.getVersionString()) > 0) {
                        this.httpsCredentialCombo.select(n);
                        Path path = (Path)c.getHttpsClientTrustKeystore().content();
                        this.arguments.setTrustStore(path.toPortableString());
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    protected void createRemoteBrowserComposite(Composite compTools) {
        GridData data = new GridData(768);
        compTools.setLayoutData((Object)data);
        compTools.setLayout((Layout)new GridLayout(2, false));
        ToolBar tocBar = new ToolBar(compTools, 0);
        ToolItem openItem = new ToolItem(tocBar, 8);
        openItem.setText("Browse");
        ToolBar navBar = new ToolBar(compTools, 0);
        navBar.setLayoutData((Object)new GridData(896));
        final ToolItem back = new ToolItem(navBar, 8);
        back.setText("Back");
        back.setEnabled(false);
        final ToolItem forward = new ToolItem(navBar, 8);
        forward.setText("Forward");
        forward.setEnabled(false);
        Composite comp = new Composite(compTools, 0);
        data = new GridData(1808);
        comp.setLayoutData((Object)data);
        comp.setLayout((Layout)new FillLayout());
        final SashForm form = new SashForm(comp, 256);
        form.setLayout((Layout)new FillLayout());
        final List list = new List((Composite)form, 4);
        try {
            browser = new Browser((Composite)form, 0);
        }
        catch (SWTError sWTError) {
            MessageBox messageBox = new MessageBox(compTools.getShell(), 33);
            messageBox.setMessage("Closing application. The Browser could not be initialized.");
            messageBox.setText("Fatal error - application terminated");
            messageBox.open();
            System.exit(-1);
        }
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                browser.back();
            }
        });
        forward.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                browser.forward();
            }
        });
        list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = list.getSelectionIndex();
                browser.setUrl(urls[index]);
            }
        });
        final LocationListener locationListener = new LocationListener(){

            public void changed(LocationEvent event) {
                Browser browser = (Browser)event.widget;
                back.setEnabled(browser.isBackEnabled());
                forward.setEnabled(browser.isForwardEnabled());
            }

            public void changing(LocationEvent event) {
            }
        };
        final TitleListener tocTitleListener = new TitleListener(){

            public void changed(TitleEvent event) {
                WsdlLocationPageWithRemoteChoice.titles[WsdlLocationPageWithRemoteChoice.index] = event.title;
            }
        };
        final ProgressListener tocProgressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                boolean tocCompleted;
                Browser browser = (Browser)event.widget;
                boolean bl = tocCompleted = ++index >= titles.length;
                if (tocCompleted) {
                    browser.dispose();
                    WsdlLocationPageWithRemoteChoice.browser = browser = new Browser((Composite)form, 0);
                    form.layout(true);
                    browser.addLocationListener(locationListener);
                    list.removeAll();
                    int i = 0;
                    while (i < titles.length) {
                        list.add(titles[i]);
                        ++i;
                    }
                    list.select(0);
                    browser.setUrl(urls[0]);
                    return;
                }
                browser.setUrl(urls[index]);
            }
        };
        openItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DirectoryDialog dialog = new DirectoryDialog(WsdlLocationPageWithRemoteChoice.this.getShell());
                String folder = dialog.open();
                if (folder == null) {
                    return;
                }
                File file = new File(folder);
                File[] files = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".html") || name.endsWith(".htm");
                    }
                });
                if (files.length == 0) {
                    return;
                }
                urls = new String[files.length];
                titles = new String[files.length];
                index = 0;
                int i = 0;
                while (i < files.length) {
                    try {
                        String url;
                        WsdlLocationPageWithRemoteChoice.urls[i] = url = files[i].toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++i;
                }
                WsdlLocationPageWithRemoteChoice.this.getShell().setText("Building index");
                browser.addTitleListener(tocTitleListener);
                browser.addProgressListener(tocProgressListener);
                if (urls.length > 0) {
                    browser.setUrl(urls[0]);
                }
            }
        });
    }

    private void updateTopControl() {
        if (this.local.getSelection()) {
            if (this.stackLayout.topControl != this.locationComposite) {
                this.setDescription(this.descriptionText);
                this.stackLayout.topControl = this.locationComposite;
                this.refreshState();
            }
        } else if (this.stackLayout.topControl != this.remoteComposite) {
            this.setDescription(Messages.wsdl_location_page_with_remote_choice_click_validate);
            this.stackLayout.topControl = this.remoteComposite;
            if (this.getSelectedProject() != null) {
                int count = this.projectsCombo.getItemCount();
                int i = 0;
                while (i < count) {
                    String tempProject = this.projectsCombo.getItem(i);
                    if (tempProject.equals(this.getSelectedProject().getName())) {
                        this.projectsCombo.select(i);
                    }
                    ++i;
                }
            }
            this.setPageComplete(false);
        }
        this.stackComposite.layout();
    }
}

