/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceClient;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class WebServiceProjectWsdlLocatorContentProvider
implements ITreeContentProvider {
    private static final String WSDL_EXTENSION = ".wsdl";
    private final IProject insertingIntoProject;

    public WebServiceProjectWsdlLocatorContentProvider() {
        this(null);
    }

    public WebServiceProjectWsdlLocatorContentProvider(IProject insertingIntoProject) {
        this.insertingIntoProject = insertingIntoProject;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return element instanceof IResource ? ((IResource)element).getParent() : null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspace) {
            return this.getChildrenFromWorkspace((IWorkspace)element);
        }
        if (element instanceof IContainer) {
            return this.getChildrenFromContainer((IContainer)element);
        }
        return new Object[0];
    }

    private boolean isAcceptableFolder(IFolder folder) {
        return true;
    }

    protected boolean isAcceptableProject(IProject project) {
        return WebServiceClient.isWebServiceClientsProject((IProject)project);
    }

    private Object[] getChildrenFromWorkspace(IWorkspace workspace) {
        IProject[] allProjects = workspace.getRoot().getProjects();
        ArrayList<IProject> wsProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject nextProject = iProjectArray[n2];
            if (nextProject.isOpen() && this.isReachableFromInsertionPoint(nextProject) && this.isAcceptableProject(nextProject)) {
                wsProjects.add(nextProject);
            }
            ++n2;
        }
        return wsProjects.toArray();
    }

    private Object[] getChildrenFromContainer(IContainer container) {
        IResource[] members;
        if (!container.isAccessible()) {
            return new Object[0];
        }
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            members = container.members();
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)ce);
            assert (false);
            return new Object[0];
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource nextResource = iResourceArray[n2];
            if (!nextResource.isDerived() && !nextResource.getName().startsWith(".")) {
                if (nextResource.getType() == 2) {
                    IFolder nextFolder = (IFolder)nextResource;
                    if (this.isAcceptableFolder(nextFolder)) {
                        children.add(nextFolder);
                    }
                } else if (nextResource.getType() == 1 && nextResource.getName().endsWith(WSDL_EXTENSION)) {
                    children.add(nextResource);
                }
            }
            ++n2;
        }
        return children.toArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReachableFromInsertionPoint(IProject projectThatMightContainWsdl) {
        if (this.insertingIntoProject == null) {
            return true;
        }
        if (this.insertingIntoProject.equals((Object)projectThatMightContainWsdl)) {
            return true;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.insertingIntoProject);
        if (javaProject == null) {
            return false;
        }
        try {
            IPath projectPath = projectThatMightContainWsdl.getFullPath();
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 2 && cp.getPath().equals((Object)projectPath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

