/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.model.WsdlParseFaildedException;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.template.WebServiceTemplateBean;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceJavaContext;
import oracle.eclipse.tools.webservices.ui.policy.model.WsdlInfo;
import oracle.eclipse.tools.webservices.ui.refactor.RefactorJavaInfo;
import oracle.eclipse.tools.webservices.ui.refactor.RefactorJavaProcessor;
import oracle.eclipse.tools.webservices.ui.refactor.RefactorJavaRefactoring;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorTemplateContext;
import oracle.eclipse.tools.webservices.ui.wizards.PolicyWizardPage;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientJavaInfo;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientProxyModelResource;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientServiceWSDLInfo;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.ClientWriterContext;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IClientProxyModel;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IOperation;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IOperations;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IOracleWebserviceClientsFile;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IPolicyReference;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IPolicyReferences;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IPortInfo;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IServiceQname;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IWebServiceClient;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.IWsdlPort;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.model.OracleWebserviceClientsFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class NewClientFromProxyWizard
extends SapphireWizard<IClientProxyModel>
implements IWorkbenchWizard {
    private IStructuredSelection selection;
    private WebServiceTemplateBean arguments;
    private PolicyWizardPage policyPage;
    private RefactorJavaRefactoring refactoring;
    private ClientJavaInfo info;
    private Listener clientProxyListener;

    public NewClientFromProxyWizard() {
        this(null, new ClientJavaInfo());
    }

    public NewClientFromProxyWizard(RefactorJavaRefactoring refactoring, ClientJavaInfo info) {
        super((Element)NewClientFromProxyWizard.createModel(info), DefinitionLoader.sdef(NewClientFromProxyWizard.class).wizard());
        if (refactoring == null) {
            RefactorJavaProcessor processor = new RefactorJavaProcessor(info);
            this.refactoring = new RefactorJavaRefactoring(processor);
        } else {
            this.refactoring = refactoring;
        }
        this.arguments = new WebServiceTemplateBean();
        this.info = info;
    }

    public IWizardPage[] getPages() {
        IWizardPage[] pages = super.getPages();
        IWizardPage[] extended = new IWizardPage[pages.length + 1];
        System.arraycopy(pages, 0, extended, 0, pages.length);
        if (this.policyPage == null) {
            this.policyPage = new PolicyWizardPage("PolicyPage", this.selection, this.arguments);
            this.policyPage.setWizard((IWizard)this);
            this.policyPage.setQueryType(QueryType.CLIENT);
        }
        extended[pages.length] = this.policyPage;
        return extended;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.info.setSelection(selection);
        IClientProxyModel element = (IClientProxyModel)this.element();
        element.initialize();
        element.refresh();
        this.info.setArguments(this.arguments);
        this.clientProxyListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ClientProxyModelResource resource;
                IMember member;
                String sMember = (String)((IClientProxyModel)event.property().element()).getPortName().content();
                if (sMember != null && NewClientFromProxyWizard.this.info.getContext() != null && (member = (resource = (ClientProxyModelResource)((IClientProxyModel)event.property().element()).resource()).getPortMemberMap().get(sMember)) != null) {
                    ClientServiceWSDLInfo mwI = new ClientServiceWSDLInfo(member, NewClientFromProxyWizard.this.info.getJavaProject());
                    try {
                        WsdlInfo wsdlInfo = mwI.findWsdlDefinition(sMember, null);
                        NewClientFromProxyWizard.this.policyPage.setWsdlInfo(wsdlInfo);
                    }
                    catch (IOException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    }
                    catch (WsdlParseFaildedException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    }
                    catch (URISyntaxException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        };
        element.getPortName().attach(this.clientProxyListener);
    }

    protected Status performFinish(ProgressMonitor monitor) {
        this.policyPage.updateArguments();
        return super.performFinish(monitor);
    }

    protected void performPostFinish() {
        if (!ValidateEditUtil.validateEdit((IFile[])new IFile[]{this.info.getSourceFile()}).isOK()) {
            return;
        }
        final PerformRefactoringOperation refactorOp = new PerformRefactoringOperation((Refactoring)this.refactoring, 6);
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                refactorOp.run(pm);
            }
        };
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, pm);
                }
                catch (CoreException ce) {
                    LoggingService.logException((String)"oracle.eclipse.tools.webservices.ui", (CoreException)ce);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnableWithProgress);
        }
        catch (InvocationTargetException ite) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices.ui", (Throwable)ite);
        }
        catch (InterruptedException ie) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices.ui", (Throwable)ie);
        }
        RefactoringStatus refactoringStatus = refactorOp.getValidationStatus();
        if (refactoringStatus != null && refactoringStatus.hasError()) {
            return;
        }
    }

    public void dispose() {
        ((IClientProxyModel)this.element()).getPortName().detach(this.clientProxyListener);
        super.dispose();
    }

    public String methodSignature(IMethod method) throws JavaModelException {
        return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)false);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected ICompilationUnit getIcu(IFile file) {
        IJavaElement elem = JavaCore.create((IFile)file);
        if (elem instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }

    private static final IClientProxyModel createModel(ClientJavaInfo info) {
        return (IClientProxyModel)IClientProxyModel.TYPE.instantiate((Resource)new ClientProxyModelResource(IClientProxyModel.TYPE, info, null));
    }

    protected Status generateOracleWebserviceClients() throws JavaModelException, ResourceStoreException {
        ClientWriterContext clientCtx = (ClientWriterContext)this.info.getContext();
        WebServiceTemplateBean bean = this.info.getArguments();
        WebServiceTemplateBean.PolicyRuntimeType type = bean.getPolicyType();
        if (WebServiceTemplateBean.PolicyRuntimeType.OWSM.equals((Object)type)) {
            IPolicyReference ref;
            IMember webServiceClient = clientCtx.getSelectionMember(IClientProxyModel.PROP_PORT_NAME.name());
            IType wsClientType = WebServiceJavaContext.findAnnotatedType("javax.xml.ws.WebServiceClient", webServiceClient);
            String name = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebServiceClient", "name", (IAnnotatable)wsClientType);
            String targetNamespace = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebServiceClient", "targetNamespace", (IAnnotatable)wsClientType);
            List<IMethod> methods = WebServiceJavaContext.findAnnotatedMethods("javax.xml.ws.WebEndpoint", webServiceClient);
            IMethod endpointMethod = null;
            for (IMethod method : methods) {
                if (method.isConstructor()) continue;
                endpointMethod = method;
                break;
            }
            String endpointName = (String)WebServiceJavaContext.findAnnotatedAttributeValue("javax.xml.ws.WebEndpoint", "name", endpointMethod);
            RefactorTemplateContext jContext = this.info.createTemplateContext();
            List<IMember> members = jContext.javaTypeClassInterfaceApplicationSearchScope(this.getQualifiedReturnType(endpointMethod));
            IMember serviceMember = null;
            for (IMember member : members) {
                if (!(member instanceof IType)) continue;
                serviceMember = member;
                break;
            }
            List<IMethod> operationMethods = WebServiceJavaContext.findAnnotatedMethods("javax.jws.WebMethod", serviceMember);
            WebServiceProject wsProject = new WebServiceProject(clientCtx.getCompilationUnit().getJavaProject());
            IFile file = wsProject.getInputWebInfLibFolder().getFile(String.valueOf(name) + ".xml");
            IOracleWebserviceClientsFile owcFile = OracleWebserviceClientsFactory.createOracleWebserviceClientFile(file);
            ((XmlResource)owcFile.adapt(XmlResource.class)).getXmlElement(true);
            IWebServiceClient wsClient = owcFile.getWebserviceClient();
            IServiceQname serviceQname = wsClient.getServiceQname();
            serviceQname.setLocalPart(name);
            serviceQname.setNamespaceUri(targetNamespace);
            IPortInfo portInfo = wsClient.getPortInfo();
            IWsdlPort wsdlPort = portInfo.getWsdlPort();
            wsdlPort.setLocalPart(endpointName);
            wsdlPort.setNamespaceUri(targetNamespace);
            IPolicyReferences pRef = portInfo.getPolicyReferences();
            Set policies = bean.getPolicies();
            for (String policy : policies) {
                if (!this.policyNotInList(pRef, PolicyType.SECURITY.name(), policy)) continue;
                ref = (IPolicyReference)pRef.getPolicyReferences().insert();
                ref.setCategory(PolicyType.SECURITY.name());
                ref.setUri(policy);
            }
            policies = bean.getAddressingPolicy();
            for (String policy : policies) {
                if (!this.policyNotInList(pRef, PolicyType.ADDRESSING.name(), policy)) continue;
                ref = (IPolicyReference)pRef.getPolicyReferences().insert();
                ref.setCategory(PolicyType.ADDRESSING.name());
                ref.setUri(policy);
            }
            policies = bean.getReliabilityPolicy();
            for (String policy : policies) {
                if (!this.policyNotInList(pRef, PolicyType.RELIABILITY.name(), policy)) continue;
                ref = (IPolicyReference)pRef.getPolicyReferences().insert();
                ref.setCategory(PolicyType.RELIABILITY.name());
                ref.setUri(policy);
            }
            policies = bean.getMtomPolicy();
            for (String policy : policies) {
                if (!this.policyNotInList(pRef, PolicyType.MTOM.name(), policy)) continue;
                ref = (IPolicyReference)pRef.getPolicyReferences().insert();
                ref.setCategory(PolicyType.MTOM.name());
                ref.setUri(policy);
            }
            IOperations operations = portInfo.getOperations();
            for (IMethod op : operationMethods) {
                if (!this.operationNotInList(operations, op.getElementName())) continue;
                IOperation ref2 = (IOperation)operations.getOperations().insert();
                ref2.setName(op.getElementName());
            }
            owcFile.resource().save();
        }
        return Status.createOkStatus();
    }

    public String getQualifiedReturnType(IMethod method) {
        if (method != null) {
            try {
                return Signature.toString((String)method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            }
        }
        return null;
    }

    public boolean policyNotInList(IPolicyReferences policyReferences, String category, String uri) {
        ElementList<IPolicyReference> refs = policyReferences.getPolicyReferences();
        for (IPolicyReference ref : refs) {
            if (ref.getCategory() == null || ref.getUri() == null || !category.equals(ref.getCategory().content()) || !uri.equals(ref.getUri().content())) continue;
            return false;
        }
        return true;
    }

    public boolean operationNotInList(IOperations operations, String name) {
        ElementList<IOperation> ops = operations.getOperations();
        for (IOperation op : ops) {
            if (op.getName() == null || !name.equals(op.getName().content())) continue;
            return false;
        }
        return true;
    }

    public RefactorJavaInfo<ClientWriterContext> getInfo() {
        return this.info;
    }
}

