/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.clientgen;

import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.clientgen.ClientGenArguments;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.JarFromAntArtifactsPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ClientGenArtifactsPage
extends JarFromAntArtifactsPage {
    private static final String PAGE_NAME = ClientGenArtifactsPage.class.getSimpleName();
    private ClientGenArguments arguments;
    private Combo serviceNames;
    private ISWTObservableValue serviceNamesObservable;
    private LightweightWsdlModel previousModel;

    public ClientGenArtifactsPage(ClientGenArguments arguments, String helpContextId) {
        super((CommonWebServiceAntTaskArguments)arguments, PAGE_NAME, Messages.clientgen_artifacts_page_title, Messages.clientgen_artifacts_page_desc, Messages.clientgen_artifacts_page_select_client_jar_dir, "clientgen_build.xml", true, helpContextId);
        this.arguments = arguments;
    }

    @Override
    public void updateArguments() {
        LightweightWsdlModel model = this.arguments.getWsdlModel();
        if (this.previousModel == model) {
            return;
        }
        if (model == null || this.serviceNames == null) {
            return;
        }
        this.serviceNames.removeAll();
        for (String service : model.getServices()) {
            this.serviceNames.add(service);
        }
        this.serviceNamesObservable.setValue((Object)this.serviceNames.getItem(0));
        super.updateArguments();
        this.previousModel = model;
    }

    @Override
    protected void setupVisualElements(Composite parent) {
        Label serviceLabel = new Label(parent, 0);
        serviceLabel.setText(Messages.clientgen_artifacts_page_service);
        serviceLabel.setLayoutData((Object)new GridData(4, 0, false, false));
        this.serviceNames = new Combo(parent, 12);
        this.serviceNames.setLayoutData((Object)new GridData(4, 0, true, false));
        Label spacer = new Label(parent, 0);
        spacer.setText("");
        super.setupVisualElements(parent);
    }

    @Override
    protected void bindToContext(DataBindingContext context) {
        super.bindToContext(context);
        this.serviceNamesObservable = SWTObservables.observeText((Control)this.serviceNames);
        context.bindValue((IObservableValue)this.serviceNamesObservable, BeansObservables.observeValue((Object)this.arguments, (String)"serviceName"), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_UPDATE), (UpdateValueStrategy)NeverUpdateStrategy.instance);
    }

    @Override
    protected IFile getDefaultDestFile() {
        IFile defaultDestFile = null;
        if (this.arguments.getProject() != null) {
            defaultDestFile = this.arguments.getWsdlIFile() == null ? this.getDefaultDestFile(this.arguments.getProject(), this.arguments.getWsdlURL()) : this.getDefaultDestFile(this.arguments.getWsdlIFile());
        } else {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (WebServiceProject.isWebServiceProject((IProject)project)) {
                    defaultDestFile = this.getDefaultDestFile(project, "ClientGen");
                    break;
                }
                ++n2;
            }
        }
        return defaultDestFile;
    }
}

