/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards.bindings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import oracle.eclipse.tools.webservices.bindings.BindingsArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.bindings.WsdlSelectionComposite;
import oracle.eclipse.tools.webservices.ui.bindings.WsdlSelectionStatusMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class WsdlLocationTablePage
extends WizardPage {
    public static final String PAGE_NAME = "WsdlLocationTablePage";
    private boolean isPageComplete = false;
    private String helpContextId;
    private final BindingsArguments arguments;
    private WsdlSelectionComposite main;
    private WsdlSelectionStatusMonitor statusMonitor;

    public WsdlLocationTablePage(BindingsArguments args, String helpContextId) {
        super(PAGE_NAME, Messages.wsdl_location_page_title, null);
        this.arguments = args;
        this.helpContextId = helpContextId;
        this.setDescription(Messages.jaxws_custom_bindings_wsdl_location_page_description);
    }

    public void createControl(Composite parent) {
        this.main = new WsdlSelectionComposite(parent, 0, this.arguments.getProject());
        this.main.addListener("WSDL_URI", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WsdlLocationTablePage.this.updateURI();
            }
        });
        this.statusMonitor = new WsdlSelectionStatusMonitor(this.main, new WsdlSelectionStatusMonitor.IStatusUpdate(){

            @Override
            public void setComplete(boolean complete) {
                WsdlLocationTablePage.this.setPageComplete(complete);
            }

            @Override
            public void setErrorMessage(String message) {
                WsdlLocationTablePage.this.setErrorMessage(message);
            }

            @Override
            public void setMessage(String message, int type) {
                WsdlLocationTablePage.this.setMessage(message, type);
            }
        });
        this.statusMonitor.start();
        this.updateURI();
        this.setControl((Control)this.main);
    }

    public void setPageComplete(boolean complete) {
        this.isPageComplete = complete;
        super.setPageComplete(complete);
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public void updateContent() {
        this.main.updateProject(this.arguments.getProject());
    }

    public void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }

    private void updateURI() {
        URI uri = this.main.getWsdlUri();
        URI oldURI = this.arguments.getWsdlURI();
        if (oldURI != uri) {
            this.arguments.setWsdlURI(uri);
        }
    }
}

