/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.util.Iterator;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.template.WebServiceTemplateBean;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.policy.IPolicySelectionPanel;
import oracle.eclipse.tools.webservices.ui.policy.WebServiceClientPolicySelectionPanel;
import oracle.eclipse.tools.webservices.ui.policy.WebServicePolicySelectionPanel;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyRuntimeType;
import oracle.eclipse.tools.webservices.ui.policy.model.WsdlInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class PolicyWizardPage
extends WizardPage {
    IPolicySelectionPanel policySelectionPanel;
    private WsdlInfo wsdlInfo;
    private WebServiceTemplateBean arguments;
    protected IPath _initialContainerFullPath;
    private IProject _project;
    private IStructuredSelection _currentSelection;
    private QueryType _queryType = QueryType.SERVER;

    public PolicyWizardPage(String pageName, IStructuredSelection selection, WebServiceTemplateBean arguments) {
        super(pageName);
        this.arguments = arguments;
        this._currentSelection = selection;
    }

    public void createControl(Composite parent) {
        this.setTitle(WebServicesUIMessages.getString("PolicyWizardPage.title"));
        this.initialPopulateProject();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        Composite panel = this.createPolicySelectionPanel(composite);
        panel.setLayoutData((Object)new GridData());
        this.setControl((Control)panel);
    }

    public void updateArguments() {
        WebServiceTemplateBean.PolicyRuntimeType type = WebServiceTemplateBean.PolicyRuntimeType.NONE;
        if (this.policySelectionPanel != null) {
            this.arguments.setPolicies(this.policySelectionPanel.getSelections(PolicyType.SECURITY));
            if (WsPolicyRuntimeType.OWSM == this.policySelectionPanel.getSelectedWsPolicyRuntimeType()) {
                type = WebServiceTemplateBean.PolicyRuntimeType.OWSM;
            } else if (WsPolicyRuntimeType.WEBLOGIC == this.policySelectionPanel.getSelectedWsPolicyRuntimeType()) {
                type = WebServiceTemplateBean.PolicyRuntimeType.WLS;
            }
            this.arguments.setAddressingPolicy(this.policySelectionPanel.getSelections(PolicyType.ADDRESSING));
            this.arguments.setMtomPolicy(this.policySelectionPanel.getSelections(PolicyType.MTOM));
            this.arguments.setReliabilityPolicy(this.policySelectionPanel.getSelections(PolicyType.RELIABILITY));
        }
        this.arguments.setPolicyType(type);
    }

    public QueryType getQueryType() {
        return this._queryType;
    }

    public void setQueryType(QueryType _queryType) {
        this._queryType = _queryType;
    }

    public void setWsdlInfo(WsdlInfo wsdlInfo) {
        this.wsdlInfo = wsdlInfo;
        if (this.policySelectionPanel != null) {
            this.policySelectionPanel.setWSDLInfo(this.wsdlInfo);
        }
    }

    private Composite createPolicySelectionPanel(Composite composite) {
        IRuntime wlsRt = this.getRuntime();
        this.policySelectionPanel = QueryType.SERVER.equals((Object)this.getQueryType()) ? new WebServicePolicySelectionPanel() : new WebServiceClientPolicySelectionPanel();
        this.policySelectionPanel.setProject(this._project);
        this.policySelectionPanel.setWSDLInfo(this.wsdlInfo);
        Composite policyComp = this.policySelectionPanel.createControl(composite, wlsRt);
        this.configureValidationStatus(policyComp);
        return policyComp;
    }

    private IRuntime getRuntime() {
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)this._project);
            if (fp.getPrimaryRuntime() != null) {
                return RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fp.getPrimaryRuntime());
            }
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e, (String)"Could not determine project");
        }
        return null;
    }

    private void configureValidationStatus(Composite comp) {
        Control[] controls;
        SapphireForm sCtrl = null;
        Control[] controlArray = controls = comp.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof SapphireForm) {
                sCtrl = (SapphireForm)control;
                break;
            }
            ++n2;
        }
        if (sCtrl == null) {
            return;
        }
        final FormComponentPart part = sCtrl.part();
        final Runnable messageUpdateOperation = new Runnable(){

            @Override
            public void run() {
                Status st = part.validation();
                if (st.severity() == Status.Severity.ERROR) {
                    PolicyWizardPage.this.setMessage(WebServicesUIMessages.getString("PolicyWizardPage.validationError"), 3);
                    PolicyWizardPage.this.setPageComplete(false);
                } else if (st.severity() == Status.Severity.WARNING) {
                    PolicyWizardPage.this.setMessage(st.message(), 2);
                    PolicyWizardPage.this.setPageComplete(true);
                } else {
                    PolicyWizardPage.this.setMessage(null);
                    PolicyWizardPage.this.setPageComplete(true);
                }
            }
        };
        messageUpdateOperation.run();
        Listener messageUpdateListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof PartValidationEvent) {
                    messageUpdateOperation.run();
                }
            }
        };
        part.attach(messageUpdateListener);
    }

    public void setContainerFullPath(IPath path) {
        this._initialContainerFullPath = path;
    }

    protected void initialPopulateProject() {
        IResource initial;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WebServiceProject.isWebServiceProject((IProject)project)) {
                this._project = project;
                break;
            }
            ++n2;
        }
        if (this._initialContainerFullPath != null && (initial = ResourcesPlugin.getWorkspace().getRoot().findMember(this._initialContainerFullPath)) != null) {
            this._project = initial.getProject();
            return;
        }
        Iterator it = this._currentSelection.iterator();
        if (it.hasNext()) {
            Object object = it.next();
            IResource selectedResource = null;
            if (object instanceof IResource) {
                selectedResource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                this._project = selectedResource.getProject();
            }
        }
    }

    public IWizardPage getNextPage() {
        this.updateArguments();
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }
}

