/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.net.URL;
import java.util.HashMap;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.AntArtifactsPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledIFileSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledTextSelector;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;

public abstract class JarFromAntArtifactsPage
extends AntArtifactsPage {
    private static final String JAR_EXTENSION = ".jar";
    private final DataBindingContext context = new DataBindingContext();
    private final CommonWebServiceAntTaskArguments arguments;
    private LabeledIFileSelector destFile;
    private String selectJarDirText;
    private final boolean allowParentEarProjectsForDestinationFile;
    private HashMap<IFile, String> defaultDestinationMap = new HashMap();

    public JarFromAntArtifactsPage(CommonWebServiceAntTaskArguments arguments, String pagename, String title, String description, String jarDirText, String antFileName, String helpContextId) {
        this(arguments, pagename, title, description, jarDirText, antFileName, false, helpContextId);
    }

    public JarFromAntArtifactsPage(CommonWebServiceAntTaskArguments arguments, String pagename, String title, String description, String jarDirText, String antFileName, boolean allowParentEarProjectsForDestinationFile, String helpContextId) {
        super(arguments, pagename, title, description, (IPath)new Path(antFileName), helpContextId);
        this.arguments = arguments;
        this.selectJarDirText = jarDirText;
        this.allowParentEarProjectsForDestinationFile = allowParentEarProjectsForDestinationFile;
    }

    @Override
    public void updateArguments() {
        super.updateArguments();
        if (this.destFile != null) {
            IFile file = this.getDefaultDestFile();
            if (this.allowParentEarProjectsForDestinationFile && file.getProject() != this.arguments.getProject()) {
                this.destFile.setDefaultPath(file.getFullPath());
            } else {
                this.destFile.setDefaultPath(file.getProjectRelativePath());
            }
        }
        this.context.updateModels();
    }

    @Override
    protected void bindToContext(DataBindingContext context) {
        super.bindToContext(context);
        this.destFile.bindToContext(context);
    }

    @Override
    protected void setupVisualElements(Composite parent) {
        IFile defaultDest = this.getDefaultDestFile();
        this.destFile = new LabeledIFileSelector(Messages.jar_from_ant_artifacts_page_jar_destination_label, Messages.jar_from_ant_artifacts_page_jar_destination_title, this.selectJarDirText, this.arguments, "destFile", this.allowParentEarProjectsForDestinationFile, (IPath)(defaultDest != null ? defaultDest.getProjectRelativePath() : new Path(".")), false, new IFieldValidator[]{IFieldValidator.jarFile}){

            @Override
            protected String determineDefault() {
                IFile file = JarFromAntArtifactsPage.this.getDefaultDestFile();
                String destination = (String)JarFromAntArtifactsPage.this.defaultDestinationMap.get(file);
                if (destination == null) {
                    destination = super.determineDefault();
                }
                return destination;
            }
        };
        this.destFile.createControl(parent);
        this.destFile.addModifyListener(new LabeledTextSelector.ITextChangeListener(){

            @Override
            public void textChanged(String text) {
                JarFromAntArtifactsPage.this.updateCachedDestFile(text);
            }
        });
        super.setupVisualElements(parent);
    }

    protected abstract IFile getDefaultDestFile();

    public IFile getDefaultDestFile(IFile xsd) {
        if (xsd == null) {
            return null;
        }
        return this.getDefaultDestFile(xsd.getProject(), xsd.getName());
    }

    public IFile getDefaultDestFile(IProject project, String fileName) {
        if (!fileName.endsWith(JAR_EXTENSION)) {
            fileName = String.valueOf(fileName) + JAR_EXTENSION;
        }
        return JarFromAntArtifactsPage.getBestJarFolderForProject(project).getFile((IPath)new Path(fileName));
    }

    public IFile getDefaultDestFile(IProject project) {
        if (project == null) {
            return null;
        }
        return this.getDefaultDestFile(project, String.valueOf(project.getName()) + JAR_EXTENSION);
    }

    protected IFile getDefaultDestFile(IProject project, URL wsdlUrl) {
        String filenameWrongExtension;
        if (wsdlUrl == null) {
            return null;
        }
        String wsdlPath = wsdlUrl.getPath();
        int lastSlash = wsdlPath.lastIndexOf(47);
        String filenameNoExtension = filenameWrongExtension = wsdlPath.substring(lastSlash);
        int lastDot = filenameWrongExtension.lastIndexOf(46);
        if (lastDot >= 0) {
            filenameNoExtension = filenameWrongExtension.substring(0, lastDot);
        }
        String filename = String.valueOf(filenameNoExtension) + JAR_EXTENSION;
        return JarFromAntArtifactsPage.getBestJarFolderForProject(project).getFile((IPath)new Path(filename));
    }

    private void updateCachedDestFile(String text) {
        IFile key = this.getDefaultDestFile();
        if (key != null) {
            if (text == null) {
                this.defaultDestinationMap.remove(key);
            } else {
                this.defaultDestinationMap.put(key, text);
            }
        }
    }
}

