/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webservices.ant.WlsAntScript;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.AntScriptBackedWizardFinisher;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AntWrapperWizard
extends Wizard
implements INewWizard {
    private final List<IAntWrapperPage> pages = new ArrayList<IAntWrapperPage>();
    private final String title;

    public AntWrapperWizard(String wizardTitle, String processTitle) {
        this.setDialogSettings(WebServicesUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(wizardTitle);
        this.setNeedsProgressMonitor(true);
        this.title = processTitle;
    }

    protected void updatePages() {
        for (IAntWrapperPage p : this.pages) {
            p.updateArguments();
        }
    }

    public void addPage(IWizardPage page) {
        if (page instanceof IAntWrapperPage) {
            this.pages.add((IAntWrapperPage)page);
        }
        super.addPage(page);
    }

    public boolean performFinish() {
        WlsAntScript script = this.createWlsAntScript();
        return new AntScriptBackedWizardFinisher(this.getContainer(), script, this.title).performFinish();
    }

    protected abstract WlsAntScript createWlsAntScript();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

