/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.webservices.ant.CommonWebServiceAntTaskArguments;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.IAntWrapperPage;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFieldValidator;
import oracle.eclipse.tools.webservices.ui.wizards.common.LabeledIFileSelector;
import oracle.eclipse.tools.webservices.ui.wizards.common.NeverUpdateStrategy;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public abstract class AntArtifactsPage
extends NewContainerWizardPage
implements IAntWrapperPage {
    private String helpContextId;
    private final DataBindingContext context = new DataBindingContext();
    private final CommonWebServiceAntTaskArguments arguments;
    private Button keepAntFileButton;
    private ISWTObservableValue keepAntFileObservable;
    private Button executeAntButton;
    private ISWTObservableValue executeAntObservable;
    private final LabeledIFileSelector destination;
    private final CheckboxGroupValidator validator;

    public AntArtifactsPage(CommonWebServiceAntTaskArguments arguments, String pagename, String title, String description, IPath defaultBuildFileName, String helpContextId) {
        super(pagename);
        this.helpContextId = helpContextId;
        this.arguments = arguments;
        this.setTitle(title);
        this.setDescription(description);
        this.destination = new LabeledIFileSelector(Messages.ant_artifacts_page_ant_script, Messages.ant_artifacts_page_ant_script_generate, Messages.ant_artifacts_page_ant_script_location, this.arguments, "antScript", false, defaultBuildFileName, false, IFieldValidator.xmlFile);
        this.validator = new CheckboxGroupValidator(Messages.ant_artifacts_page_noruntime, 1, Messages.ant_artifacts_page_checkbox_select);
    }

    @Override
    public void updateArguments() {
        if (this.hasRuntime()) {
            this.executeAntObservable.setValue((Object)true);
            this.executeAntButton.setEnabled(true);
            this.executeAntButton.setText(Messages.ant_artifacts_page_ant_script_execute);
            this.keepAntFileObservable.setValue((Object)false);
            this.destination.setEnabled(false);
            this.destination.resetDefaults();
            this.updateStatus((IStatus)new Status(0, "oracle.eclipse.tools.webservices.ui", ""));
        } else {
            this.executeAntObservable.setValue((Object)false);
            this.executeAntButton.setEnabled(false);
            this.executeAntButton.setText(Messages.ant_artifacts_page_ant_script_execute_noruntime);
            this.keepAntFileObservable.setValue((Object)true);
            this.destination.setEnabled(true);
            this.updateStatus((IStatus)new Status(2, "oracle.eclipse.tools.webservices.ui", Messages.ant_artifacts_page_noruntime));
        }
        this.context.updateModels();
        this.context.updateTargets();
    }

    public final void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.context);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        this.setupVisualElements(composite);
        this.bindToContext(this.context);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void bindToContext(DataBindingContext context) {
        this.destination.bindToContext(context);
        UpdateModelsSelectionAdatper adapter = new UpdateModelsSelectionAdatper();
        this.keepAntFileButton.addSelectionListener((SelectionListener)adapter);
        UpdateValueStrategy strategy = new UpdateValueStrategy().setBeforeSetValidator((IValidator)this.validator);
        this.keepAntFileObservable = SWTObservables.observeSelection((Control)this.keepAntFileButton);
        context.bindValue((IObservableValue)this.keepAntFileObservable, BeansObservables.observeValue((Object)this.arguments, (String)"generateAntScript"), strategy, (UpdateValueStrategy)NeverUpdateStrategy.instance);
        this.executeAntObservable = SWTObservables.observeSelection((Control)this.executeAntButton);
        context.bindValue((IObservableValue)this.executeAntObservable, BeansObservables.observeValue((Object)this.arguments, (String)"executeAnt"), strategy, (UpdateValueStrategy)NeverUpdateStrategy.instance);
    }

    protected void setupVisualElements(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        group.setText(Messages.ant_artifacts_page_ant_script_generate);
        group.setLayout((Layout)new GridLayout(3, false));
        this.executeAntButton = this.createCheckBox((Composite)group, Messages.ant_artifacts_page_ant_script_execute, 3);
        this.keepAntFileButton = this.createCheckBox((Composite)group, Messages.ant_artifacts_page_ant_script_keep, 3);
        this.destination.createControl((Composite)group);
    }

    protected void setDefaultAntFile(IPath projectRelativeDefault) {
        this.destination.setDefaultPath(projectRelativeDefault);
    }

    protected static IContainer getBestJarFolderForProject(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            if (WtpProjectUtil.isEarProject((IProject)project)) {
                IContainer appInfLib = AntArtifactsPage.getMemberFromComponent(component, "APP-INF/lib");
                if (appInfLib != null) {
                    return appInfLib;
                }
            } else if (WtpProjectUtil.isDynamicWebProject((IProject)project)) {
                IContainer webInfLib = AntArtifactsPage.getMemberFromComponent(component, "WEB-INF/lib");
                if (webInfLib != null) {
                    return webInfLib;
                }
            } else {
                Set earReferences = WtpProjectUtil.findReferencingEarProjects((IProject)project);
                for (IProject earProject : earReferences) {
                    if (!WtpProjectUtil.hasProjectFacet((IProject)earProject, (IProjectFacet)WlsEarFacet.FACET)) continue;
                    return AntArtifactsPage.getBestJarFolderForProject(earProject);
                }
                Set<IProject> warReferences = AntArtifactsPage.findReferencingWarProjects(project);
                if (warReferences.size() > 0) {
                    return AntArtifactsPage.getBestJarFolderForProject(warReferences.iterator().next());
                }
            }
        }
        return project;
    }

    private static IContainer getMemberFromComponent(IVirtualComponent component, String dir) {
        IResource[] appinflibs;
        IVirtualFolder earRoot = component.getRootFolder();
        IVirtualResource virtualWebinflib = earRoot.findMember(dir);
        if (virtualWebinflib == null) {
            return null;
        }
        IResource[] iResourceArray = appinflibs = virtualWebinflib.getUnderlyingResources();
        int n = appinflibs.length;
        int n2 = 0;
        while (n2 < n) {
            IResource appinflib = iResourceArray[n2];
            if (!appinflib.isDerived() && appinflib instanceof IFolder) {
                return (IFolder)appinflib;
            }
            ++n2;
        }
        return null;
    }

    private static final Set<IProject> findReferencingWarProjects(IProject project) {
        HashSet<IProject> referencing = new HashSet<IProject>();
        for (IProject war : WtpProjectUtil.findDynamicWebProjects()) {
            if (!WtpProjectUtil.findReferencedProjects((IProject)war).contains(project)) continue;
            referencing.add(war);
        }
        return Collections.unmodifiableSet(referencing);
    }

    private boolean hasRuntime() {
        IProject project = this.arguments.getProject();
        try {
            return project != null && project.getAdapter(WSRuntime.class) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private Button createCheckBox(Composite parent, String label, int horizontalSpan) {
        Button b = new Button(parent, 32);
        b.setText(label);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        b.setLayoutData((Object)gd);
        this.validator.addCheckbox(b);
        return b;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.context.updateTargets();
        }
        super.setVisible(visible);
    }

    public final void performHelp() {
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
        }
    }

    private class CheckboxGroupValidator
    extends SelectionAdapter
    implements IValidator {
        private final List<Button> checkboxes = new ArrayList<Button>();
        private final int minimum;
        private final String msgMin;
        private final String msgNoRuntime;

        public CheckboxGroupValidator(String errMsgNoRuntime, int minimumSelected, String errorMessageMinSelected) {
            this.minimum = minimumSelected;
            this.msgMin = errorMessageMinSelected;
            this.msgNoRuntime = errMsgNoRuntime;
        }

        public IStatus validate(Object value) {
            int selected = 0;
            for (Button b : this.checkboxes) {
                if (b.getSelection()) {
                    ++selected;
                }
                if (selected >= this.minimum) break;
            }
            if (selected < this.minimum) {
                return new Status(4, "oracle.eclipse.tools.webservices.ui", this.msgMin);
            }
            if (!AntArtifactsPage.this.hasRuntime()) {
                return new Status(2, "oracle.eclipse.tools.webservices.ui", this.msgNoRuntime);
            }
            return Status.OK_STATUS;
        }

        public void addCheckbox(Button b) {
            this.checkboxes.add(b);
            b.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            AntArtifactsPage.this.context.updateModels();
        }
    }

    private class UpdateModelsSelectionAdatper
    extends SelectionAdapter {
        private UpdateModelsSelectionAdatper() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == AntArtifactsPage.this.keepAntFileButton) {
                AntArtifactsPage.this.destination.setEnabled(AntArtifactsPage.this.keepAntFileButton.getSelection());
            }
        }
    }
}

