/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.refactor.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.w3c.dom.Node;

public class RefactorRegion
implements IRegion {
    private List<RefactorRegion> _regions = new ArrayList<RefactorRegion>();
    private String localName = "";
    private int length;
    private int offset = -1;
    private int firstChildOffset;
    private int lastChildOffset;

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getStartOffset() {
        if (this.offset < 1) {
            return this.offset;
        }
        return this.offset - 1;
    }

    public int getFirstChildOffset() {
        return this.firstChildOffset;
    }

    public void setFirstChildOffset(int firstChildOffset) {
        this.firstChildOffset = firstChildOffset;
    }

    public int getLastChildOffset() {
        return this.lastChildOffset;
    }

    public void setLastChildOffset(int lastChildOffset) {
        this.lastChildOffset = lastChildOffset;
    }

    public int getLength() {
        return this.length + 1;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.length;
    }

    public boolean containsOffset(int offset) {
        return this.getOffset() <= offset && offset < this.getEndOffset();
    }

    public List<RefactorRegion> getRegions() {
        return this._regions;
    }

    public void addRegion(RefactorRegion elementRegion) {
        this._regions.add(elementRegion);
    }

    public RefactorRegion getRegionAtCharacterOffset(int offset) {
        if (this.containsOffset(offset)) {
            for (RefactorRegion region : this.getRegions()) {
                RefactorRegion nestedRegion = region.getRegionAtCharacterOffset(offset);
                if (nestedRegion == null) continue;
                return nestedRegion;
            }
            return this;
        }
        return null;
    }

    public RefactorRegion getRegionAtNode(Node node) {
        if (this.localName != null && this.localName.equals(node.getNodeName())) {
            return this;
        }
        for (RefactorRegion region : this.getRegions()) {
            RefactorRegion nestedRegion = region.getRegionAtNode(node);
            if (nestedRegion == null) continue;
            return nestedRegion;
        }
        return null;
    }
}

