/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.refactor;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.ASTInvocationContext;
import oracle.eclipse.tools.webservices.ui.refactor.RefactorJavaInfo;
import oracle.eclipse.tools.webservices.ui.refactor.template.JavaRegionProvider;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorRegion;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorTemplateContext;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorTemplateProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

class RefactorJavaDelegate {
    private final RefactorJavaInfo<?> info;
    private final Map<IFile, Integer> refactorFiles;
    private RefactorRegion refactorRegion;

    RefactorJavaDelegate(RefactorJavaInfo<?> info) {
        this.info = info;
        this.refactorFiles = new HashMap<IFile, Integer>();
    }

    RefactoringStatus checkInitialConditions() {
        RefactoringStatus result = new RefactoringStatus();
        IFile sourceFile = this.info.getSourceFile();
        if (sourceFile == null || !sourceFile.exists()) {
            result.addFatalError(Messages.refactorDelegate_noSourceFile);
        } else if (this.info.getSourceFile().isReadOnly()) {
            result.addFatalError(Messages.refactorDelegate_roFile);
        }
        return result;
    }

    RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(Messages.refactorDelegate_checking, 100);
        pm.worked(50);
        if (!this.isValidRegion(this.info)) {
            result.addFatalError(Messages.refactorDelegate_notValid);
        } else if (ctxt != null) {
            IFile[] files = new IFile[this.refactorFiles.size()];
            this.refactorFiles.keySet().toArray(files);
            IConditionChecker checker = ctxt.getChecker(ValidateEditChecker.class);
            ValidateEditChecker editChecker = (ValidateEditChecker)checker;
            editChecker.addFiles(files);
        }
        pm.done();
        return result;
    }

    void createChange(IProgressMonitor pm, CompositeChange rootChange) throws CoreException {
        try {
            pm.beginTask(Messages.refactorDelegate_collectingChanges, 100);
            rootChange.add(this.createRefactorChange(pm));
            pm.worked(10);
        }
        finally {
            pm.done();
        }
    }

    private Change createRefactorChange(IProgressMonitor pm) throws CoreException {
        IFile file = this.info.getSourceFile();
        CompilationUnitChange result = new CompilationUnitChange(file.getName(), ((ASTInvocationContext)this.info.getContext()).getWriterContext().getICompilationUnit());
        this.info.setDocument(result.getCurrentDocument(pm));
        this.info.setOffset(this.refactorRegion.getStartOffset());
        this.info.setLength(this.refactorRegion.getLength());
        MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
        result.setEdit((TextEdit)fileChangeRootEdit);
        result.setKeepPreviewEdits(true);
        try {
            TextEdit astEdits;
            List<String> imports = this.info.getImports();
            for (String clazz : imports) {
                WriterUtil.ensureImport((String)clazz, (WriterContext)((ASTInvocationContext)this.info.getContext()).getWriterContext());
            }
            if (this.info.getLength() != -1) {
                this.setReplaceEdit(result, fileChangeRootEdit);
            }
            if (this.info.getContext() != null && ((ASTInvocationContext)this.info.getContext()).getWriterContext() != null && !RefactorJavaDelegate.isEmptyEdit(astEdits = ((ASTInvocationContext)this.info.getContext()).getWriterContext().getASTRewrite().rewriteAST())) {
                fileChangeRootEdit.addChild(astEdits);
                String astUpdateName = "AST Edits";
                result.addTextEditGroup(new TextEditGroup(astUpdateName, astEdits));
            }
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (TemplateException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        return result;
    }

    private static boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    private void setReplaceEdit(CompilationUnitChange change, MultiTextEdit fileChangeRootEdit) throws IOException, CoreException, BadLocationException, TemplateException {
        RefactorTemplateContext context = this.info.createTemplateContext();
        Template[] templates = RefactorTemplateProcessor.computeRefactorTemplates(context);
        context.setReadOnly(false);
        Template template = this.getTemplateForThisContext(context, templates);
        TemplateBuffer buffer = context.evaluate(template);
        String formattedBuffer = this.formatBodyDeclaration(buffer.getString());
        ReplaceEdit edit = new ReplaceEdit(this.info.getOffset(), this.info.getLength(), formattedBuffer);
        fileChangeRootEdit.addChild((TextEdit)edit);
    }

    public String formatBodyDeclaration(String bodyDeclaration) throws BadLocationException {
        IJavaProject javaProject = this.info.getJavaProject();
        IDocument javaDocument = this.info.getDocument();
        String content = javaDocument.get(this.info.getOffset(), this.info.getLength());
        int count = 1;
        while (count < this.info.getLength()) {
            char val = content.charAt(this.info.getLength() - count);
            if ('}' == val) break;
            ++count;
        }
        int indentation = this.getIndentation(javaDocument, javaProject, this.info.getOffset());
        InsertEdit iEdit = new InsertEdit(this.info.getLength() - count, bodyDeclaration);
        if (iEdit != null) {
            Document iDoc = new Document(content);
            iEdit.apply((IDocument)iDoc);
            bodyDeclaration = iDoc.get();
        }
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)javaDocument);
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)javaProject.getOptions(true));
        TextEdit formatEdit = formatter.format(4, bodyDeclaration, 0, bodyDeclaration.length(), indentation, delimiter);
        if (formatEdit != null) {
            Document genDoc = new Document(bodyDeclaration);
            formatEdit.apply((IDocument)genDoc);
            bodyDeclaration = genDoc.get();
        }
        return bodyDeclaration;
    }

    private int getIndentation(IDocument document, IJavaProject project, int offset) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String lineContent = document.get(region.getOffset(), region.getLength());
            return IndentManipulation.measureIndentUnits((CharSequence)lineContent, (int)this.getTabWidth(project), (int)this.getIndentWidth(project));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int getTabWidth(IJavaProject project) {
        String key = "space".equals(this.getJavaCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return this.getJavaCoreOption(project, key, 4);
    }

    private int getIndentWidth(IJavaProject project) {
        String key = "mixed".equals(this.getJavaCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return this.getJavaCoreOption(project, key, 4);
    }

    private int getJavaCoreOption(IJavaProject project, String key, int def) {
        try {
            return Integer.parseInt(this.getJavaCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private String getJavaCoreOption(IJavaProject project, String key) {
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private Template getTemplateForThisContext(RefactorTemplateContext context, Template[] templates) {
        String templateName = context.getTemplateID();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().equals(templateName)) {
                return template;
            }
            ++n2;
        }
        return templates[0];
    }

    private boolean isValidRegion(RefactorJavaInfo<?> info) {
        boolean result = false;
        try {
            this.refactorRegion = JavaRegionProvider.createRefactorRegion(info);
            return this.refactorRegion != null && this.refactorRegion.getOffset() != -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
    }
}

