/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.Expression;

public class WebServiceRefAnnotationElement
extends AnnotationElement {
    private Expression value;
    private Expression name;
    private Expression mappedName;
    private Expression type;
    private Expression wsdlLocation;

    static {
        DEFAULT_VALUES.put(WebServiceRefPropertyTypes.TYPE, "Object");
        DEFAULT_VALUES.put(WebServiceRefPropertyTypes.VALUE, "Object");
    }

    public WebServiceRefAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebServiceRefPropertyTypes type = WebServiceRefPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    this.setValue(value);
                    break;
                }
                case NAME: {
                    this.setName(value);
                    break;
                }
                case MAPPEDNAME: {
                    this.setMappedName(value);
                    break;
                }
                case TYPE: {
                    this.setType(value);
                    break;
                }
                case WSDLLOCATION: {
                    this.setWsdlLocation(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebServiceRefPropertyTypes type = WebServiceRefPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    return this.getValue();
                }
                case NAME: {
                    return this.getName();
                }
                case MAPPEDNAME: {
                    return this.getMappedName();
                }
                case TYPE: {
                    return this.getType();
                }
                case WSDLLOCATION: {
                    return this.getWsdlLocation();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebServiceRef;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(Expression mappedName) {
        this.mappedName = mappedName;
    }

    public Expression getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(Expression wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setType(Expression type) {
        this.type = type;
    }

    public Expression getType() {
        return this.type;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebServiceRefPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebServiceRefPropertyTypes.getPropertyType(id);
    }

    @Override
    public void setElementValue(String identifier, String value) {
        if (value != null && (WebServiceRefPropertyTypes.TYPE.getIdentifier().equals(identifier) || WebServiceRefPropertyTypes.VALUE.getIdentifier().equals(identifier))) {
            IStatus status = JavaConventions.validateJavaTypeName((String)value, (String)"1.6", (String)"1.6");
            if (status.isOK()) {
                super.setElementValue(identifier, value);
            }
        } else {
            super.setElementValue(identifier, value);
        }
    }

    @Override
    public IStatus validateElementValue(String identifier, String value) {
        if (value != null && (WebServiceRefPropertyTypes.TYPE.getIdentifier().equals(identifier) || WebServiceRefPropertyTypes.VALUE.getIdentifier().equals(identifier))) {
            IStatus status = JavaConventions.validateJavaTypeName((String)value, (String)"1.6", (String)"1.6");
            return status;
        }
        return Status.OK_STATUS;
    }

    public static enum WebServiceRefPropertyTypes implements IPropertyTypes
    {
        MAPPEDNAME("mappedName"),
        NAME("name"),
        TYPE("type"),
        VALUE("value"),
        WSDLLOCATION("wsdlLocation");

        private String name;

        private WebServiceRefPropertyTypes(String name) {
            this.name = name;
        }

        public static WebServiceRefPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebServiceRefPropertyTypes[] webServiceRefPropertyTypesArray = WebServiceRefPropertyTypes.values();
                int n = webServiceRefPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServiceRefPropertyTypes temp = webServiceRefPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

