/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebServiceProviderAnnotationElement
extends AnnotationElement {
    private Expression portName;
    private Expression serviceName;
    private Expression targetNamespace;
    private Expression wsdlLocation;

    public WebServiceProviderAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebServiceProviderPropertyTypes type = WebServiceProviderPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case PORTNAME: {
                    this.setPortName(value);
                    break;
                }
                case SERVICENAME: {
                    this.setServiceName(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
                case WSDLLOCATION: {
                    this.setWsdlLocation(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebServiceProviderPropertyTypes type = WebServiceProviderPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case PORTNAME: {
                    return this.getPortName();
                }
                case SERVICENAME: {
                    return this.getServiceName();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
                case WSDLLOCATION: {
                    return this.getWsdlLocation();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebServiceProvider;
    }

    public Expression getPortName() {
        return this.portName;
    }

    public void setPortName(Expression portName) {
        this.portName = portName;
    }

    public Expression getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(Expression serviceName) {
        this.serviceName = serviceName;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public Expression getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(Expression wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebServiceProviderPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebServiceProviderPropertyTypes.getPropertyType(id);
    }

    public static enum WebServiceProviderPropertyTypes implements IPropertyTypes
    {
        PORTNAME("portName"),
        SERVICENAME("serviceName"),
        TARGETNAMESPACE("targetNamespace"),
        WSDLLOCATION("wsdlLocation");

        private String name;

        private WebServiceProviderPropertyTypes(String name) {
            this.name = name;
        }

        public static WebServiceProviderPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebServiceProviderPropertyTypes[] webServiceProviderPropertyTypesArray = WebServiceProviderPropertyTypes.values();
                int n = webServiceProviderPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServiceProviderPropertyTypes temp = webServiceProviderPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

