/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebServiceClientAnnotationElement
extends AnnotationElement {
    private Expression targetNamespace;
    private Expression wsdlLocation;
    private Expression name;

    public WebServiceClientAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebServiceClientPropertyTypes type = WebServiceClientPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    this.setName(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
                case WSDLLOCATION: {
                    this.setWsdlLocation(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebServiceClientPropertyTypes type = WebServiceClientPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    return this.getName();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
                case WSDLLOCATION: {
                    return this.getWsdlLocation();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebServiceClient;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public Expression getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(Expression wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebServiceClientPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebServiceClientPropertyTypes.getPropertyType(id);
    }

    public static enum WebServiceClientPropertyTypes implements IPropertyTypes
    {
        NAME("name"),
        TARGETNAMESPACE("targetNamespace"),
        WSDLLOCATION("wsdlLocation");

        private String name;

        private WebServiceClientPropertyTypes(String name) {
            this.name = name;
        }

        public static WebServiceClientPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebServiceClientPropertyTypes[] webServiceClientPropertyTypesArray = WebServiceClientPropertyTypes.values();
                int n = webServiceClientPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServiceClientPropertyTypes temp = webServiceClientPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

