/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebServiceAnnotationElement
extends AnnotationElement {
    private Expression portName;
    private Expression serviceName;
    private Expression targetNamespace;
    private Expression wsdlLocation;
    private Expression name;
    private Expression endpointInterface;

    public WebServiceAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebServicePropertyTypes type = WebServicePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    this.setName(value);
                    break;
                }
                case PORTNAME: {
                    this.setPortName(value);
                    break;
                }
                case SERVICENAME: {
                    this.setServiceName(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
                case WSDLLOCATION: {
                    this.setWsdlLocation(value);
                    break;
                }
                case ENDPOINTINTERFACE: {
                    this.setEndpointInterface(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebServicePropertyTypes type = WebServicePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    return this.getName();
                }
                case PORTNAME: {
                    return this.getPortName();
                }
                case SERVICENAME: {
                    return this.getServiceName();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
                case WSDLLOCATION: {
                    return this.getWsdlLocation();
                }
                case ENDPOINTINTERFACE: {
                    return this.getEndpointInterface();
                }
            }
        }
        return null;
    }

    public Expression getPortName() {
        return this.portName;
    }

    public void setPortName(Expression portName) {
        this.portName = portName;
    }

    public Expression getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(Expression serviceName) {
        this.serviceName = serviceName;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public Expression getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(Expression wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getEndpointInterface() {
        return this.endpointInterface;
    }

    public void setEndpointInterface(Expression endpointInterface) {
        this.endpointInterface = endpointInterface;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebService;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebServicePropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebServicePropertyTypes.getPropertyType(id);
    }

    public static enum WebServicePropertyTypes implements IPropertyTypes
    {
        PORTNAME("portName"),
        SERVICENAME("serviceName"),
        TARGETNAMESPACE("targetNamespace"),
        WSDLLOCATION("wsdlLocation"),
        NAME("name"),
        ENDPOINTINTERFACE("endpointInterface");

        private String name;

        private WebServicePropertyTypes(String name) {
            this.name = name;
        }

        public static WebServicePropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebServicePropertyTypes[] webServicePropertyTypesArray = WebServicePropertyTypes.values();
                int n = webServicePropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServicePropertyTypes wsTemp = webServicePropertyTypesArray[n2];
                    if (wsTemp.getIdentifier().equals(name)) {
                        return wsTemp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

