/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebResultAnnotationElement
extends AnnotationElement {
    private static final String[] HEADER = new String[]{"true", "false"};
    private Expression name;
    private Expression partName;
    private Expression header;
    private Expression targetNamespace;

    static {
        DEFAULT_VALUES.put(WebResultPropertyTypes.HEADER, HEADER[1]);
    }

    public WebResultAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebResultPropertyTypes type = WebResultPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    this.setName(value);
                    break;
                }
                case PARTNAME: {
                    this.setPartName(value);
                    break;
                }
                case HEADER: {
                    this.setHeader(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebResultPropertyTypes type = WebResultPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    return this.getName();
                }
                case PARTNAME: {
                    return this.getPartName();
                }
                case HEADER: {
                    return this.getHeader();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebResult;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getPartName() {
        return this.partName;
    }

    public void setPartName(Expression partName) {
        this.partName = partName;
    }

    public Expression getHeader() {
        return this.header;
    }

    public void setHeader(Expression header) {
        this.header = header;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebResultPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebResultPropertyTypes.getPropertyType(id);
    }

    public static enum WebResultPropertyTypes implements IPropertyTypes
    {
        NAME("name"),
        PARTNAME("partName"),
        TARGETNAMESPACE("targetNamespace"),
        HEADER("header");

        private String name;

        private WebResultPropertyTypes(String name) {
            this.name = name;
        }

        public static WebResultPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebResultPropertyTypes[] webResultPropertyTypesArray = WebResultPropertyTypes.values();
                int n = webResultPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebResultPropertyTypes temp = webResultPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

