/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebMethodAnnotationElement
extends AnnotationElement {
    private static final String[] EXCLUDE = new String[]{"true", "false"};
    private Expression action;
    private Expression operationName;
    private Expression exclude;

    static {
        DEFAULT_VALUES.put(WebMethodPropertyTypes.EXCLUDE, EXCLUDE[1]);
    }

    public WebMethodAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebMethodPropertyTypes type = WebMethodPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case ACTION: {
                    this.setAction(value);
                    break;
                }
                case OPERATIONNAME: {
                    this.setOperationName(value);
                    break;
                }
                case EXCLUDE: {
                    this.setExclude(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebMethodPropertyTypes type = WebMethodPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case ACTION: {
                    return this.getAction();
                }
                case OPERATIONNAME: {
                    return this.getOperationName();
                }
                case EXCLUDE: {
                    return this.getExclude();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebMethod;
    }

    public Expression getAction() {
        return this.action;
    }

    public void setAction(Expression action) {
        this.action = action;
    }

    public Expression getOperationName() {
        return this.operationName;
    }

    public void setOperationName(Expression operationName) {
        this.operationName = operationName;
    }

    public Expression getExclude() {
        return this.exclude;
    }

    public void setExclude(Expression exclude) {
        this.exclude = exclude;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebMethodPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebMethodPropertyTypes.getPropertyType(id);
    }

    public static enum WebMethodPropertyTypes implements IPropertyTypes
    {
        OPERATIONNAME("operationName"),
        ACTION("action"),
        EXCLUDE("exclude");

        private String name;

        private WebMethodPropertyTypes(String name) {
            this.name = name;
        }

        public static WebMethodPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebMethodPropertyTypes[] webMethodPropertyTypesArray = WebMethodPropertyTypes.values();
                int n = webMethodPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebMethodPropertyTypes temp = webMethodPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

