/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class SoapBindingAnnotationElement
extends AnnotationElement {
    private static final String[] USE = new String[]{"LITERAL", "ENCODED"};
    private static final String[] STYLE = new String[]{"DOCUMENT"};
    private static final String[] PARAMETERSTYLE = new String[]{"WRAPPED"};
    private Expression use;
    private Expression style;
    private Expression parameterStyle;

    static {
        DEFAULT_VALUES.put(SoapBindingPropertyTypes.USE, USE[0]);
        DEFAULT_VALUES.put(SoapBindingPropertyTypes.STYLE, STYLE[0]);
        DEFAULT_VALUES.put(SoapBindingPropertyTypes.PARAMETERSTYLE, PARAMETERSTYLE[0]);
    }

    public SoapBindingAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        SoapBindingPropertyTypes type = SoapBindingPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case USE: {
                    this.setUse(value);
                    break;
                }
                case STYLE: {
                    this.setStyle(value);
                    break;
                }
                case PARAMETERSTYLE: {
                    this.setParameterStyle(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        SoapBindingPropertyTypes type = SoapBindingPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case USE: {
                    return this.getUse();
                }
                case STYLE: {
                    return this.getStyle();
                }
                case PARAMETERSTYLE: {
                    return this.getParameterStyle();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.SOAPBinding;
    }

    public Expression getUse() {
        return this.use;
    }

    public void setUse(Expression use) {
        this.use = use;
    }

    public Expression getStyle() {
        return this.style;
    }

    public void setStyle(Expression style) {
        this.style = style;
    }

    public Expression getParameterStyle() {
        return this.parameterStyle;
    }

    public void setParameterStyle(Expression parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return SoapBindingPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return SoapBindingPropertyTypes.getPropertyType(id);
    }

    public static enum SoapBindingPropertyTypes implements IPropertyTypes
    {
        STYLE("style"),
        USE("use"),
        PARAMETERSTYLE("parameterStyle");

        private String name;

        private SoapBindingPropertyTypes(String name) {
            this.name = name;
        }

        public static SoapBindingPropertyTypes getPropertyType(String name) {
            if (name != null) {
                SoapBindingPropertyTypes[] soapBindingPropertyTypesArray = SoapBindingPropertyTypes.values();
                int n = soapBindingPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SoapBindingPropertyTypes temp = soapBindingPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

