/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class ServiceModeAnnotationElement
extends AnnotationElement {
    private Expression value;
    private static final String[] VALUE = new String[]{"PAYLOAD", "MESSAGE"};

    static {
        DEFAULT_VALUES.put(ServiceModePropertyTypes.VALUE, VALUE[0]);
    }

    public ServiceModeAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        ServiceModePropertyTypes type = ServiceModePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    this.setValue(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        ServiceModePropertyTypes type = ServiceModePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    return this.getValue();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.ServiceMode;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return ServiceModePropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return ServiceModePropertyTypes.getPropertyType(id);
    }

    public static enum ServiceModePropertyTypes implements IPropertyTypes
    {
        VALUE("value");

        private String name;

        private ServiceModePropertyTypes(String name) {
            this.name = name;
        }

        public static ServiceModePropertyTypes getPropertyType(String name) {
            if (name != null) {
                ServiceModePropertyTypes[] serviceModePropertyTypesArray = ServiceModePropertyTypes.values();
                int n = serviceModePropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceModePropertyTypes temp = serviceModePropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

