/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.IAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.PolicyAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public class SecurityPolicyAnnotationElement
extends AnnotationElement {
    private Expression uri;

    public SecurityPolicyAnnotationElement(JavaElement parent) {
        super(parent);
    }

    public Expression getUri() {
        return this.uri;
    }

    public void setUri(Expression uri) {
        this.uri = uri;
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        SecurityPolicyPropertyTypes type = SecurityPolicyPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case URI: {
                    this.setUri(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        SecurityPolicyPropertyTypes type = SecurityPolicyPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case URI: {
                    return this.getUri();
                }
            }
        }
        return null;
    }

    @Override
    public IAnnotationType getAnnotationType() {
        return PolicyAnnotationType.SecurityPolicy;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return SecurityPolicyPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return SecurityPolicyPropertyTypes.getPropertyType(id);
    }

    public static enum SecurityPolicyPropertyTypes implements IPropertyTypes
    {
        URI("uri");

        private String name;

        private SecurityPolicyPropertyTypes(String name) {
            this.name = name;
        }

        public static SecurityPolicyPropertyTypes getPropertyType(String name) {
            if (name != null) {
                SecurityPolicyPropertyTypes[] securityPolicyPropertyTypesArray = SecurityPolicyPropertyTypes.values();
                int n = securityPolicyPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SecurityPolicyPropertyTypes temp = securityPolicyPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

