/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.preference;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.preference.IWsPolicyStorePreference;
import oracle.eclipse.tools.webservices.ui.policy.preference.WsPolicyStorePreferenceModelFactory;
import oracle.eclipse.tools.webservices.ui.policy.preference.WsPolicyStorePreferenceModelResource;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;

public class WsPolicyStorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWsPolicyStorePreference model = null;
    IRuntimeLifecycleListener listener = null;
    SapphireForm wsPolicyPrefPanel = null;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebServicesUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtil.glayout((int)1));
        this.model = WsPolicyStorePreferenceModelFactory.create(this.getPreferenceStore());
        SapphireForm wsPolicyPrefPanel = new SapphireForm(composite, (Element)this.model, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).form());
        wsPolicyPrefPanel.setLayoutData((Object)SwtUtil.gdhfill());
        this.addRuntimeListener();
        return composite;
    }

    private void addRuntimeListener() {
        this.listener = new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WsPolicyStorePreferencePage.this.model.refresh();
                        try {
                            WsPolicyStorePreferencePage.this.model.resource().save();
                        }
                        catch (ResourceStoreException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public void runtimeChanged(IRuntime runtime) {
                WeblogicPolicyUtil.resetPolicyQueryCache();
            }

            public void runtimeAdded(IRuntime runtime) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WsPolicyStorePreferencePage.this.model.refresh();
                        try {
                            WsPolicyStorePreferencePage.this.model.resource().save();
                        }
                        catch (ResourceStoreException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.listener);
    }

    public void dispose() {
        super.dispose();
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.listener);
    }

    protected void performApply() {
        super.performApply();
        WsPolicyStorePreferenceModelResource res = (WsPolicyStorePreferenceModelResource)this.model.resource();
        res.save();
        WeblogicPolicyUtil.resetPolicyQueryCache();
    }
}

