/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.webservices.ui.policy.preference.IRuntimePolicyStore;
import oracle.eclipse.tools.webservices.ui.policy.preference.IWsPolicyStorePreference;
import oracle.eclipse.tools.webservices.ui.policy.preference.PolicyStoreType;
import oracle.eclipse.tools.webservices.ui.policy.preference.RuntimePolicyStoreModelResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class WsPolicyStorePreferenceModelResource
extends Resource {
    public static final String WS_FILESTORE_TYPE_PREFERENCE = "WS_FILESTORE_TYPE_PREFERENCE";
    public static final String WS_OVERRIDE_FILESTORE_PREFERENCE = "WS_OVERRIDE_FILESTORE_PREFERENCE";
    public static final String WS_REMOTE_POLICY_STORE_PREFERENCE = "WS_REMOTE_POLICY_STORE_PREFERENCE";
    private Map<String, String> policyStoreTypeMap = new HashMap<String, String>();
    private Map<String, String> overridePolicyStoreLocMap = new HashMap<String, String>();
    private Map<String, String> remotePolicyStoreMap = new HashMap<String, String>();
    private IPreferenceStore prefStore;

    public WsPolicyStorePreferenceModelResource(IPreferenceStore store) {
        super(null);
        this.prefStore = store;
        this.initPolicyStorePrefMaps();
    }

    private void initPolicyStorePrefMaps() {
        ArrayList<IRuntime> wlsRuntimeList = new ArrayList<IRuntime>();
        Set rts = WebLogicServerUtil.getWebLogicRuntimes();
        for (IRuntime rt : rts) {
            File path = rt.getLocation().toFile();
            if (!JRFRuntimeUtil.isJRFRuntimeInstalled((File)path)) continue;
            wlsRuntimeList.add(rt);
        }
        if (rts.size() > 0) {
            String remotePolicyStore;
            String overrideFileStore;
            int n;
            String isUsingFileStore = this.prefStore.getString(WS_FILESTORE_TYPE_PREFERENCE);
            if (isUsingFileStore.length() > 0) {
                String[] stringArray = isUsingFileStore.split(";");
                n = stringArray.length;
                int path = 0;
                while (path < n) {
                    String s = stringArray[path];
                    String[] kv = s.split("=");
                    this.policyStoreTypeMap.put(kv[0], kv[1]);
                    ++path;
                }
            }
            if ((overrideFileStore = this.prefStore.getString(WS_OVERRIDE_FILESTORE_PREFERENCE)).length() > 0) {
                String[] stringArray = overrideFileStore.split(";");
                int n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String s = stringArray[n];
                    String[] kv = s.split("=");
                    this.overridePolicyStoreLocMap.put(kv[0], kv[1]);
                    ++n;
                }
            }
            if ((remotePolicyStore = this.prefStore.getString(WS_REMOTE_POLICY_STORE_PREFERENCE)).length() > 0) {
                String[] stringArray = remotePolicyStore.split(";");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    String[] kv = s.split("=");
                    this.remotePolicyStoreMap.put(kv[0], kv[1]);
                    ++n4;
                }
            }
        }
    }

    String getStoreType(IRuntime rt) {
        return this.policyStoreTypeMap.get(rt.getId());
    }

    void setStoreType(IRuntime rt, String type) {
        this.policyStoreTypeMap.put(rt.getId(), type != null ? type : "DEFAULT");
        this.element().property(IWsPolicyStorePreference.PROP_RUNTIME_POLICY_STORE).refresh();
        if (type == null || !type.equals(PolicyStoreType.REMOTE.toString())) {
            this.remotePolicyStoreMap.remove(rt.getId());
        }
        if (type == null || !type.equals(PolicyStoreType.OVERRIDE.toString())) {
            this.overridePolicyStoreLocMap.remove(rt.getId());
        }
        this.element().property(IWsPolicyStorePreference.PROP_RUNTIME_POLICY_STORE).refresh();
    }

    String getOverrideLocation(IRuntime rt) {
        return this.overridePolicyStoreLocMap.get(rt.getId());
    }

    void setOverrideLocation(IRuntime rt, String location) {
        this.overridePolicyStoreLocMap.put(rt.getId(), location);
    }

    WsPolicyStorePreferenceModelResource(Resource parent) {
        super(parent);
    }

    String getRemoteServerName(IRuntime rt) {
        return this.remotePolicyStoreMap.get(rt.getId());
    }

    void setRemoteServerName(IRuntime rt, String id) {
        this.remotePolicyStoreMap.put(rt.getId(), id);
    }

    protected PropertyBinding createBinding(Property property) {
        if (property.definition() == IWsPolicyStorePreference.PROP_RUNTIME_POLICY_STORE) {
            return this.createRuntimePolicyStorePrefList(property);
        }
        return null;
    }

    private ListPropertyBinding createRuntimePolicyStorePrefList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                ArrayList<IRuntime> wlsRuntimeList = new ArrayList<IRuntime>();
                Set rts = WebLogicServerUtil.getWebLogicRuntimes();
                for (IRuntime rt : rts) {
                    File path = rt.getLocation().toFile();
                    if (!JRFRuntimeUtil.isJRFRuntimeInstalled((File)path)) continue;
                    wlsRuntimeList.add(rt);
                }
                ArrayList<IRuntime> runtimes = new ArrayList<IRuntime>();
                for (IRuntime r : wlsRuntimeList) {
                    runtimes.add(r);
                }
                return runtimes;
            }

            protected Resource resource(Object obj) {
                return new RuntimePolicyStoreModelResource(WsPolicyStorePreferenceModelResource.this, obj);
            }

            public ElementType type(Resource obj) {
                return IRuntimePolicyStore.TYPE;
            }
        };
        return listBinding;
    }

    public void save() {
        HashSet<String> runtimeIds = new HashSet<String>();
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime rt = iRuntimeArray[n2];
            runtimeIds.add(rt.getId());
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String k : this.policyStoreTypeMap.keySet()) {
            if (!runtimeIds.contains(k)) continue;
            sb.append(String.valueOf(k) + '=' + this.policyStoreTypeMap.get(k) + ';');
        }
        this.prefStore.setValue(WS_FILESTORE_TYPE_PREFERENCE, sb.toString());
        sb = new StringBuilder();
        for (String k : this.overridePolicyStoreLocMap.keySet()) {
            if (!runtimeIds.contains(k)) continue;
            sb.append(String.valueOf(k) + '=' + this.overridePolicyStoreLocMap.get(k) + ';');
        }
        this.prefStore.setValue(WS_OVERRIDE_FILESTORE_PREFERENCE, sb.toString());
        sb = new StringBuilder();
        for (String k : this.remotePolicyStoreMap.keySet()) {
            if (!runtimeIds.contains(k)) continue;
            sb.append(String.valueOf(k) + '=' + this.remotePolicyStoreMap.get(k) + ';');
        }
        this.prefStore.setValue(WS_REMOTE_POLICY_STORE_PREFERENCE, sb.toString());
    }
}

