/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.preference;

import java.io.File;
import oracle.eclipse.tools.webservices.ui.policy.preference.IRuntimePolicyStore;
import oracle.eclipse.tools.webservices.ui.policy.preference.PolicyStoreType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class OverrideLocationValidator
extends ValidationService {
    protected Status compute() {
        Value val = (Value)this.context(Value.class);
        String storePath = val.text(true);
        IRuntimePolicyStore policyStore = (IRuntimePolicyStore)val.element();
        if (policyStore.getPolicyStoreType().content() == PolicyStoreType.OVERRIDE) {
            if (storePath == null) {
                return Status.createErrorStatus((String)"Override WS policy store location cannot be null.");
            }
            File storeRoot = new File(storePath);
            if (!storeRoot.exists()) {
                return Status.createErrorStatus((String)"Invalid WS policy store location: direcotry not exists");
            }
            File policyDir = new File(storeRoot, "/owsm/policies/oracle");
            if (!policyDir.exists()) {
                return Status.createErrorStatus((String)("Invalid WS policy store location. Direcotry  found : " + policyDir.getAbsolutePath()));
            }
        }
        return Status.createOkStatus();
    }
}

