/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.model;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.policy.model.IOwsmPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWeblogicWsPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.OwsmPolicyModelResource;
import oracle.eclipse.tools.webservices.ui.policy.model.WeblogicPolicyModelResource;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyRuntimeType;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.wst.server.core.IRuntime;

public class WsPolicyConfigModelResource
extends Resource {
    private WsPolicyRuntimeType type = WsPolicyRuntimeType.NONE;
    private QueryType queryType = QueryType.SERVER;
    private List<WsPolicy> owsmPolicies = new ArrayList<WsPolicy>();
    private List<WsPolicy> owsmCompatPolicies = new ArrayList<WsPolicy>();
    private List<WsPolicy> wlsPolicies = new ArrayList<WsPolicy>();
    private IRuntime runtime = null;
    private IProject project = null;

    public WsPolicyConfigModelResource(IRuntime runtime, IProject proj, WsPolicyRuntimeType type, List<WsPolicy> owsmPolicies, List<WsPolicy> wlsPolicies) {
        super(null);
        if (owsmPolicies != null) {
            this.owsmPolicies = owsmPolicies;
        }
        if (wlsPolicies != null) {
            this.wlsPolicies = wlsPolicies;
        }
        this.type = type;
        this.runtime = runtime;
        this.project = proj;
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public IProject getProject() {
        return this.project;
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IWsPolicyConfig.PROP_POLICY_RUNTIME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    if (WsPolicyConfigModelResource.this.type == null || WsPolicyConfigModelResource.this.type == WsPolicyRuntimeType.NONE) {
                        return null;
                    }
                    return WsPolicyConfigModelResource.this.type.toString();
                }

                public void write(String value) {
                    if (value == null) {
                        WsPolicyConfigModelResource.this.type = null;
                    } else {
                        WsPolicyConfigModelResource.this.type = WsPolicyRuntimeType.valueOf(value);
                    }
                }
            };
        }
        if (p == IWsPolicyConfig.PROP_QUERY_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return WsPolicyConfigModelResource.this.queryType.toString();
                }

                public void write(String value) {
                    WsPolicyConfigModelResource.this.queryType = QueryType.valueOf((String)value);
                }
            };
        }
        if (p == IWsPolicyConfig.PROP_OWSM_POLICIES) {
            return this.createOwsmPolicyList(property);
        }
        if (p == IWsPolicyConfig.PROP_OWSM_COMPAT_POLICIES) {
            return this.createOwsmCompatPolicyList(property);
        }
        if (p == IWsPolicyConfig.PROP_WEBLOGIC_POLICIES) {
            return this.createWeblogicPolicyList(property);
        }
        if (p instanceof ValueProperty) {
            return new ValuePropertyBinding(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        }
        return null;
    }

    private PropertyBinding createWeblogicPolicyList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                return WsPolicyConfigModelResource.this.wlsPolicies;
            }

            protected Resource resource(Object obj) {
                return new WeblogicPolicyModelResource(WsPolicyConfigModelResource.this, obj);
            }

            public ElementType type(Resource obj) {
                return IWeblogicWsPolicy.TYPE;
            }

            protected Object insertUnderlyingObject(ElementType type, int position) {
                String newPolicy = "policy:" + System.currentTimeMillis();
                WsPolicy wsPolicy = new WsPolicy(newPolicy);
                WsPolicyConfigModelResource.this.wlsPolicies.add(position, wsPolicy);
                return wsPolicy;
            }

            public void remove(Resource resource) {
                WeblogicPolicyModelResource res = (WeblogicPolicyModelResource)resource;
                boolean removed = WsPolicyConfigModelResource.this.wlsPolicies.remove(res.getPolicyObject());
                boolean debug = false;
                if (debug) {
                    System.out.println("Removed " + removed);
                }
            }
        };
        return listBinding;
    }

    private PropertyBinding createOwsmPolicyList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                return WsPolicyConfigModelResource.this.owsmPolicies;
            }

            protected Resource resource(Object obj) {
                return new OwsmPolicyModelResource(WsPolicyConfigModelResource.this, obj);
            }

            public ElementType type(Resource obj) {
                return IOwsmPolicy.TYPE;
            }

            protected Object insertUnderlyingObject(ElementType type, int position) {
                Object obj = this.insertUnderlyingObject(type);
                return obj;
            }

            private Object insertUnderlyingObject(ElementType type) {
                String newPolicy = "oracle/" + System.currentTimeMillis();
                WsPolicy wsPolicy = new WsPolicy(newPolicy);
                WsPolicyConfigModelResource.this.owsmPolicies.add(wsPolicy);
                return wsPolicy;
            }

            public void remove(Resource resource) {
                OwsmPolicyModelResource res = (OwsmPolicyModelResource)resource;
                boolean removed = WsPolicyConfigModelResource.this.owsmPolicies.remove(res.getPolicyObject());
                boolean debug = false;
                if (debug) {
                    System.out.println("Removed " + removed);
                }
            }
        };
        return listBinding;
    }

    private PropertyBinding createOwsmCompatPolicyList(Property property) {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                return WsPolicyConfigModelResource.this.owsmCompatPolicies;
            }

            protected Resource resource(Object obj) {
                return new OwsmPolicyModelResource(WsPolicyConfigModelResource.this, obj);
            }

            public ElementType type(Resource obj) {
                return IOwsmPolicy.TYPE;
            }

            protected Object insertUnderlyingObject(ElementType type, int position) {
                Object obj = this.insertUnderlyingObject(type);
                return obj;
            }

            private Object insertUnderlyingObject(ElementType type) {
                String newPolicy = "oracle/" + System.currentTimeMillis();
                WsPolicy wsPolicy = new WsPolicy(newPolicy);
                WsPolicyConfigModelResource.this.owsmCompatPolicies.add(wsPolicy);
                return wsPolicy;
            }

            public void remove(Resource resource) {
                OwsmPolicyModelResource res = (OwsmPolicyModelResource)resource;
                boolean removed = WsPolicyConfigModelResource.this.owsmCompatPolicies.remove(res.getPolicyObject());
                boolean debug = false;
                if (debug) {
                    System.out.println("Removed " + removed);
                }
            }
        };
        return listBinding;
    }
}

