/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.policy.IPolicySelectionPanel;
import oracle.eclipse.tools.webservices.ui.policy.model.IOwsmPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWeblogicWsPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelFactory;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyRuntimeType;
import oracle.eclipse.tools.webservices.ui.policy.model.WsdlInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;

public class WebServicePolicySelectionPanel
implements IPolicySelectionPanel {
    private static final String SELECTION_PANEL_SDEF = "main.panel";
    private static final String OWSM_PANEL_SDEF = "owsm.panel";
    private static final String WLS_PANEL_SDEF = "weblogic.panel";
    private IWsPolicyConfig model = null;
    private WsPolicyRuntimeType policyOption = WsPolicyRuntimeType.NONE;
    private QueryType queryType = QueryType.SERVER;
    private IRuntime wlsRt = null;
    private IProject project = null;
    private Set<String> selection = Collections.emptySet();
    private List<String> existingOwsmPolicies = new ArrayList<String>();
    private List<String> existingWlsPolicies = new ArrayList<String>();

    private String getSdefName() {
        if (WsPolicyRuntimeType.OWSM == this.policyOption) {
            return OWSM_PANEL_SDEF;
        }
        if (WsPolicyRuntimeType.WEBLOGIC == this.policyOption) {
            return WLS_PANEL_SDEF;
        }
        return SELECTION_PANEL_SDEF;
    }

    public void setWsPolicyRuntimeType(WsPolicyRuntimeType policyOption) {
        if (policyOption != null) {
            this.policyOption = policyOption;
        }
    }

    public WsPolicyRuntimeType getWsPolicyRuntimeType() {
        return this.policyOption;
    }

    @Override
    public WsPolicyRuntimeType getSelectedWsPolicyRuntimeType() {
        return (WsPolicyRuntimeType)((Object)this.model.getPolicyRuntimeType().content());
    }

    @Override
    public void setProject(IProject proj) {
        this.project = proj;
    }

    @Override
    public Composite createControl(Composite parent, IRuntime wlsRt) {
        this.wlsRt = wlsRt;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdfill());
        composite.setLayout((Layout)SwtUtil.glayout((int)1));
        this.model = WsPolicyConfigModelFactory.create(this.wlsRt, this.project, this.getWsPolicyRuntimeType(), this.existingOwsmPolicies, this.existingWlsPolicies);
        this.model.setQueryType(this.queryType);
        GridData gd = SwtUtil.gdfill();
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 640;
        gd.heightHint = 360;
        SapphireForm wsPolicyPrefPanel = new SapphireForm(composite, (Element)this.model, DefinitionLoader.context(this.getClass()).sdef("WebServicePolicySelection").form(this.getSdefName()));
        wsPolicyPrefPanel.setLayoutData((Object)gd);
        return composite;
    }

    @Override
    public Set<String> getSelections(PolicyType type) {
        block2: {
            WsPolicyRuntimeType prt;
            block3: {
                this.selection = new HashSet<String>();
                prt = (WsPolicyRuntimeType)((Object)this.model.getPolicyRuntimeType().content());
                if (!PolicyType.SECURITY.equals((Object)type)) break block2;
                if (WsPolicyRuntimeType.OWSM != prt) break block3;
                for (IOwsmPolicy p : this.model.getOwsmPolicies()) {
                    this.selection.add((String)p.getPolicyName().content());
                }
                break block2;
            }
            if (WsPolicyRuntimeType.WEBLOGIC != prt) break block2;
            for (IWeblogicWsPolicy p : this.model.getWeblogicPolicies()) {
                String uri = (String)p.getPolicyName().content();
                this.selection.add(uri);
            }
        }
        return this.selection;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    @Override
    public void setWSDLInfo(WsdlInfo wsdlInfo) {
    }
}

