/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy;

import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelResource;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;

public class PolicyDescriptionCompositeFactory
extends FormComponentPart {
    public FormComponentPresentation createPresentation(SwtPresentation parent, final Composite composite) {
        return new FormComponentPresentation(this, parent, composite){
            Text description;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.description = null;
            }

            public void render() {
                GridData gd = new GridData();
                gd.heightHint = 120;
                gd.widthHint = 625;
                gd.horizontalSpan = 2;
                gd.grabExcessHorizontalSpace = true;
                composite.setLayoutData((Object)gd);
                this.description = new Text(composite, 74);
                gd = new GridData();
                gd.horizontalSpan = 2;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalIndent = 8;
                this.description.setLayoutData((Object)gd);
                final IWsPolicyConfig model = (IWsPolicyConfig)PolicyDescriptionCompositeFactory.this.getModelElement();
                WsPolicyConfigModelResource policyConfig = (WsPolicyConfigModelResource)model.resource();
                final IRuntime rt = policyConfig.getRuntime();
                Control[] children = composite.getShell().getChildren();
                final Table table = this.findTableControl((Composite)children[0]);
                if (table != null) {
                    table.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            int n = table.getSelectionIndex();
                            if (n >= 0) {
                                String policyName = table.getItem(n).getText(0);
                                QueryType type = (QueryType)model.getQueryType().content();
                                String text = WeblogicPolicyUtil.getPolicyDescription(rt, policyName, type);
                                description.setText(text);
                                description.getShell().layout(true, true);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
            }

            private Table findTableControl(Composite parent) {
                Control[] children;
                Control[] controlArray = children = parent.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Table t;
                    Control cc = controlArray[n2];
                    if (cc instanceof Composite && (t = this.findTableControl((Composite)cc)) != null && this.containsPolicy(t)) {
                        return t;
                    }
                    if (cc instanceof Table) {
                        return (Table)cc;
                    }
                    ++n2;
                }
                return null;
            }

            private boolean containsPolicy(Table t) {
                TableColumn[] cols = t.getColumns();
                String policyName = "Policy";
                TableColumn[] tableColumnArray = cols;
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn col = tableColumnArray[n2];
                    if (col.getText() != null && col.getText().contains(policyName)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }
}

